/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.JsonPatchConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceObjectRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bitstream")
public class BitstreamRestRepository
extends DSpaceObjectRestRepository<Bitstream, BitstreamRest> {
    private final BitstreamService bs;
    @Autowired
    BundleService bundleService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private CommunityService communityService;
    @Autowired
    private HandleService handleService;
    @Autowired
    ConfigurationService configurationService;

    @Autowired
    public BitstreamRestRepository(BitstreamService dsoService) {
        super(dsoService);
        this.bs = dsoService;
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'BITSTREAM', 'METADATA_READ')")
    public BitstreamRest findOne(Context context, UUID id) {
        Bitstream bit = null;
        try {
            bit = this.bs.find(context, id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bit == null) {
            return null;
        }
        try {
            if (bit.isDeleted()) {
                throw new ResourceNotFoundException();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (BitstreamRest)this.converter.toRest(bit, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<BitstreamRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("bitstream", "findAll");
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'BITSTREAM', 'WRITE')")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws AuthorizeException, SQLException {
        this.patchDSpaceObject(apiCategory, model, id, patch);
    }

    @Override
    public Class<BitstreamRest> getDomainClass() {
        return BitstreamRest.class;
    }

    @Override
    protected void delete(Context context, UUID id) throws AuthorizeException {
        Bitstream bit = null;
        try {
            Collection collection;
            bit = this.bs.find(context, id);
            if (bit == null) {
                throw new ResourceNotFoundException("The bitstream with uuid " + id + " could not be found");
            }
            if (bit.isDeleted()) {
                throw new ResourceNotFoundException("The bitstream with uuid " + id + " was already deleted");
            }
            Community community = bit.getCommunity();
            if (community != null) {
                this.communityService.setLogo(context, community, null);
            }
            if ((collection = bit.getCollection()) != null) {
                this.collectionService.setLogo(context, collection, null);
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            this.bs.delete(context, (DSpaceObject)bit);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byItemHandle")
    public BitstreamRest findByItemHandle(@Parameter(value="handle", required=true) String handle, @Parameter(value="sequence") Integer sequence, @Parameter(value="filename") String filename) {
        if (StringUtils.isBlank((CharSequence)filename) && sequence == null) {
            throw new IllegalArgumentException("The request should include a sequence or a filename");
        }
        try {
            Context context = this.obtainContext();
            DSpaceObject dSpaceObject = this.handleService.resolveToObject(context, handle);
            if (!(dSpaceObject instanceof Item)) {
                throw new UnprocessableEntityException("The provided handle does not correspond to an existing item");
            }
            Item item = (Item)dSpaceObject;
            Bitstream matchedBitstream = this.getFirstMatchedBitstream(item, sequence, filename);
            if (matchedBitstream == null) {
                return null;
            }
            return (BitstreamRest)this.converter.toRest(matchedBitstream, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Bitstream getFirstMatchedBitstream(Item item, Integer sequence, String filename) {
        List bundles = item.getBundles();
        LinkedList bitstreams = new LinkedList();
        bundles.forEach(bundle -> bitstreams.addAll(bundle.getBitstreams()));
        if (sequence != null) {
            for (Bitstream bitstream : bitstreams) {
                if (bitstream.getSequenceID() != sequence.intValue()) continue;
                return bitstream;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            for (Bitstream bitstream : bitstreams) {
                if (!StringUtils.equals((CharSequence)bitstream.getName(), (CharSequence)filename)) continue;
                return bitstream;
            }
        }
        return null;
    }

    public InputStream retrieve(UUID uuid) {
        InputStream is;
        Context context = this.obtainContext();
        Bitstream bit = null;
        try {
            bit = this.bs.find(context, uuid);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bit == null) {
            return null;
        }
        try {
            is = this.bs.retrieve(context, bit);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        context.abort();
        return is;
    }

    public BundleRest performBitstreamMove(Context context, Bitstream bitstream, Bundle targetBundle) throws SQLException, IOException, AuthorizeException {
        if (bitstream.getBundles().contains(targetBundle)) {
            throw new DSpaceBadRequestException("The provided bitstream is already in the target bundle");
        }
        this.bundleService.moveBitstreamToBundle(context, targetBundle, bitstream);
        return (BundleRest)this.converter.toRest(targetBundle, this.utils.obtainProjection());
    }

    public void patchBitstreamsInBulk(Context context, JsonNode jsonNode) throws SQLException {
        int operationsLimit = this.configurationService.getIntProperty("rest.patch.operations.limit", 1000);
        ObjectMapper mapper = new ObjectMapper();
        JsonPatchConverter patchConverter = new JsonPatchConverter(mapper);
        Patch patch = patchConverter.convert(jsonNode);
        if (patch.getOperations().size() > operationsLimit) {
            throw new DSpaceBadRequestException("The number of operations in the patch is over the limit of " + operationsLimit);
        }
        this.resourcePatch.patch(this.obtainContext(), null, patch.getOperations());
        context.commit();
    }
}

