/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.CrossLinks;
import org.dspace.content.authority.DSpaceControlledVocabularyIndex;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="discover.browse")
public class BrowseIndexRestRepository
extends DSpaceRestRepository<BrowseIndexRest, String> {
    @Autowired
    private ChoiceAuthorityService choiceAuthorityService;

    @Override
    @PreAuthorize(value="permitAll()")
    public BrowseIndexRest findOne(Context context, String name) {
        BrowseIndexRest bi = this.createFromMatchingBrowseIndex(name);
        if (bi == null) {
            bi = this.createFromMatchingVocabulary(name);
        }
        return bi;
    }

    private BrowseIndexRest createFromMatchingVocabulary(String name) {
        DSpaceControlledVocabularyIndex vocabularyIndex = this.choiceAuthorityService.getVocabularyIndex(name);
        if (vocabularyIndex != null) {
            return (BrowseIndexRest)this.converter.toRest(vocabularyIndex, this.utils.obtainProjection());
        }
        return null;
    }

    private BrowseIndexRest createFromMatchingBrowseIndex(String name) {
        BrowseIndex bix;
        try {
            bix = BrowseIndex.getBrowseIndex((String)name);
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bix != null) {
            return (BrowseIndexRest)this.converter.toRest(bix, this.utils.obtainProjection());
        }
        return null;
    }

    @Override
    public Page<BrowseIndexRest> findAll(Context context, Pageable pageable) {
        try {
            ArrayList<BrowseIndex> indexes = new ArrayList<BrowseIndex>(Arrays.asList(BrowseIndex.getBrowseIndices()));
            this.choiceAuthorityService.getChoiceAuthoritiesNames().stream().filter(name -> this.choiceAuthorityService.getVocabularyIndex(name) != null).forEach(name -> indexes.add((BrowseIndex)this.choiceAuthorityService.getVocabularyIndex(name)));
            return this.converter.toRestPage(indexes, pageable, indexes.size(), this.utils.obtainProjection());
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byFields")
    public BrowseIndexRest findByFields(@Parameter(value="fields", required=true) String[] fields) throws SQLException {
        BrowseIndexRest bi = null;
        BrowseIndex bix = null;
        try {
            String[] stringArray = fields;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                CrossLinks cl = new CrossLinks();
                String field = stringArray[i];
                if (!cl.hasLink(field)) continue;
                String browseIndexName = cl.getLinkType(field);
                bix = BrowseIndex.getBrowseIndex((String)browseIndexName);
                break;
            }
        }
        catch (BrowseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (bix != null) {
            bi = (BrowseIndexRest)this.converter.toRest(bix, this.utils.obtainProjection());
        }
        return bi;
    }

    @Override
    public Class<BrowseIndexRest> getDomainClass() {
        return BrowseIndexRest.class;
    }
}

