/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.community.adminGroup")
public class CommunityAdminGroupLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private CommunityService communityService;

    @PreAuthorize(value="hasPermission(#communityId, 'COMMUNITY', 'READ')")
    public GroupRest getAdminGroup(@Nullable HttpServletRequest request, UUID communityId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Community community = (Community)this.communityService.find(context, communityId);
            if (community == null) {
                throw new ResourceNotFoundException("No such community: " + communityId);
            }
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Community)community);
            }
            catch (AuthorizeException e) {
                throw new AccessDeniedException("The current user was not allowed to retrieve the AdminGroup for community: " + communityId);
            }
            Group administrators = community.getAdministrators();
            if (administrators == null) {
                return null;
            }
            return (GroupRest)this.converter.toRest(administrators, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

