/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.service.SubscribeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.subscription.resource")
public class SubscriptionDSpaceObjectLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private SubscribeService subscribeService;

    @PreAuthorize(value="hasPermission(#subscriptionId, 'subscription', 'READ')")
    public DSpaceObjectRest getDSpaceObject(@Nullable HttpServletRequest request, Integer subscriptionId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Subscription subscription = this.subscribeService.findById(this.obtainContext(), subscriptionId.intValue());
            if (Objects.isNull(subscription)) {
                throw new ResourceNotFoundException("No such subscription: " + subscriptionId);
            }
            return (DSpaceObjectRest)this.converter.toRest(subscription.getDSpaceObject(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

