/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler;

import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.repository.handler.ExternalSourceEntryItemUriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.service.OrcidQueueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalSourceEntryOrcidQueueUriListHandler
extends ExternalSourceEntryItemUriListHandler<OrcidQueue> {
    @Autowired
    private OrcidQueueService orcidQueueService;

    @Override
    public boolean supports(List<String> uriList, String method, Class clazz) {
        return clazz == OrcidQueue.class;
    }

    @Override
    public boolean validate(Context context, HttpServletRequest request, List<String> uriList) throws AuthorizeException {
        return uriList.size() <= 1;
    }

    @Override
    public OrcidQueue handle(Context context, HttpServletRequest request, List<String> uriList) throws SQLException, AuthorizeException {
        return this.getObjectFromUriList(context, uriList);
    }

    private OrcidQueue getObjectFromUriList(Context context, List<String> uriList) {
        OrcidQueue orcidQueue = null;
        String url = uriList.get(0);
        Pattern pattern = Pattern.compile("\\/api\\/eperson\\/orcidqueues\\/(.*)");
        Matcher matcher = pattern.matcher(url);
        matcher.find();
        String id = matcher.group(1);
        int queueId = Integer.parseInt(id);
        try {
            orcidQueue = this.orcidQueueService.find(context, queueId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return orcidQueue;
    }
}

