/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.ResourcePolicyRestPermissionEvaluatorPlugin;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyAdminPermissionEvalutatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(ResourcePolicyRestPermissionEvaluatorPlugin.class);
    public static final String RESOURCE_POLICY_PATCH = "resourcepolicy";
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.ADMIN.equals((Object)restPermission) || !StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)RESOURCE_POLICY_PATCH)) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
        try {
            int resourcePolicyID = Integer.parseInt(targetId.toString());
            ResourcePolicy resourcePolicy = this.resourcePolicyService.find(context, resourcePolicyID);
            if (resourcePolicy == null) {
                throw new ResourceNotFoundException("authz.resourcepolicy with id: " + resourcePolicyID + " not found");
            }
            DSpaceObject dso = resourcePolicy.getdSpaceObject();
            return this.authorizeService.isAdmin(context, dso);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

