/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class AnonymousAdditionalAuthorizationFilterIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private GroupService groupService;
    public static final String[] IP = new String[]{"org.dspace.authenticate.IPAuthentication"};
    public static final String[] IP_AND_PASS = new String[]{"org.dspace.authenticate.IPAuthentication", "org.dspace.authenticate.PasswordAuthentication"};
    public static final String[] PASS = new String[]{"org.dspace.authenticate.PasswordAuthentication"};
    Item staffAccessItem1;
    Group staff;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.staff = GroupBuilder.createGroup((Context)this.context).withName("Staff").build();
        this.staffAccessItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").withReaderGroup(this.staff).build();
    }

    @Test
    public void verifyIPAuthentication() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)IP);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).with(AnonymousAdditionalAuthorizationFilterIT.ip("5.5.5.5"))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"5.5.5.5"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).with(AnonymousAdditionalAuthorizationFilterIT.ip("6.6.6.6"))).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"6.6.6.6"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void verifyIPAndPasswordAuthentication() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)IP_AND_PASS);
        this.groupService.addMember(this.context, this.staff, this.eperson);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).with(AnonymousAdditionalAuthorizationFilterIT.ip("5.5.5.5"))).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"5.5.5.5"})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).with(AnonymousAdditionalAuthorizationFilterIT.ip("6.6.6.6"))).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"6.6.6.6"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(this.getAuthTokenWithXForwardedForHeader(this.eperson.getEmail(), this.password, "6.6.6.6")).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"6.6.6.6"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void verifyPasswordAuthentication() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASS);
        this.groupService.addMember(this.context, this.staff, this.eperson);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"5.5.5.5"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"6.6.6.6"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(this.getAuthTokenWithXForwardedForHeader(this.eperson.getEmail(), this.password, "6.6.6.6")).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.staffAccessItem1.getID()), (Object[])new Object[0]).header("X-Forwarded-For", new Object[]{"6.6.6.6"})).andExpect(MockMvcResultMatchers.status().isOk());
    }
}

