/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.epo.service.EpoImportMetadataSourceServiceImpl;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class EpoImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private LiveImportClientImpl liveImportClient;
    @Autowired
    private EpoImportMetadataSourceServiceImpl epoServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void epoImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        InputStream file2token = null;
        InputStream file = null;
        InputStream file2 = null;
        InputStream file3 = null;
        String originKey = this.epoServiceImpl.getConsumerKey();
        String originSecret = this.epoServiceImpl.getConsumerSecret();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try {
            file2token = ((Object)((Object)this)).getClass().getResourceAsStream("epo-token.json");
            file = ((Object)((Object)this)).getClass().getResourceAsStream("epo-resp.xml");
            file2 = ((Object)((Object)this)).getClass().getResourceAsStream("epo-first.xml");
            file3 = ((Object)((Object)this)).getClass().getResourceAsStream("epo-second.xml");
            String tokenResp = IOUtils.toString((InputStream)file2token, (Charset)Charset.defaultCharset());
            String epoResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            String epoResp2 = IOUtils.toString((InputStream)file2, (Charset)Charset.defaultCharset());
            String epoResp3 = IOUtils.toString((InputStream)file3, (Charset)Charset.defaultCharset());
            this.epoServiceImpl.setConsumerKey("test-key");
            this.epoServiceImpl.setConsumerSecret("test-secret");
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse responseWithToken = this.mockResponse(tokenResp, 200, "OK");
            CloseableHttpResponse response1 = this.mockResponse(epoResp, 200, "OK");
            CloseableHttpResponse response2 = this.mockResponse(epoResp2, 200, "OK");
            CloseableHttpResponse response3 = this.mockResponse(epoResp3, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)responseWithToken, (Object[])new CloseableHttpResponse[]{response1, response2, response3});
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.epoServiceImpl.getRecords("test query", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            if (Objects.nonNull(file2token)) {
                file2token.close();
            }
            if (Objects.nonNull(file)) {
                file.close();
            }
            if (Objects.nonNull(file2)) {
                file2.close();
            }
            if (Objects.nonNull(file3)) {
                file3.close();
            }
            this.epoServiceImpl.setConsumerKey(originKey);
            this.epoServiceImpl.setConsumerSecret(originSecret);
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void epoImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        InputStream file = null;
        InputStream file2 = null;
        String originKey = this.epoServiceImpl.getConsumerKey();
        String originSecret = this.epoServiceImpl.getConsumerSecret();
        CloseableHttpClient originalHttpClient = this.liveImportClient.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try {
            file = ((Object)((Object)this)).getClass().getResourceAsStream("epo-token.json");
            file2 = ((Object)((Object)this)).getClass().getResourceAsStream("epo-resp.xml");
            String token = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            String epoResp = IOUtils.toString((InputStream)file2, (Charset)Charset.defaultCharset());
            this.epoServiceImpl.setConsumerKey("test-key");
            this.epoServiceImpl.setConsumerSecret("test-secret");
            this.liveImportClient.setHttpClient(httpClient);
            CloseableHttpResponse responseWithToken = this.mockResponse(token, 200, "OK");
            CloseableHttpResponse response1 = this.mockResponse(epoResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)responseWithToken, (Object[])new CloseableHttpResponse[]{response1});
            this.context.restoreAuthSystemState();
            int tot = this.epoServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)10000L, (long)tot);
        }
        finally {
            if (Objects.nonNull(file)) {
                file.close();
            }
            if (Objects.nonNull(file2)) {
                file2.close();
            }
            this.epoServiceImpl.setConsumerKey(originKey);
            this.epoServiceImpl.setConsumerSecret(originSecret);
            this.liveImportClient.setHttpClient(originalHttpClient);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO identifierOther = this.createMetadatumDTO("dc", "identifier", "other", "epodoc:ES2902749T");
        MetadatumDTO identifier = this.createMetadatumDTO("dc", "identifier", null, "18705153");
        MetadatumDTO date = this.createMetadatumDTO("dc", "date", "issued", "2022-01-29");
        MetadatumDTO dateSubmitted = this.createMetadatumDTO("dc", "date", "submitted", "2018-01-19");
        MetadatumDTO applicant = this.createMetadatumDTO("dc", "contributor", null, "PANKA BLOOD TEST GMBH");
        MetadatumDTO applicant2 = this.createMetadatumDTO("dc", "contributor", null, "Panka Blood Test GmbH");
        MetadatumDTO author = this.createMetadatumDTO("dc", "contributor", "author", "PANTEL KLAUS");
        MetadatumDTO author2 = this.createMetadatumDTO("dc", "contributor", "author", " BARTKOWIAK KAI");
        MetadatumDTO author3 = this.createMetadatumDTO("dc", "contributor", "author", "PANTEL, Klaus, ");
        MetadatumDTO author4 = this.createMetadatumDTO("dc", "contributor", "author", "BARTKOWIAK, Kai");
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "M\u00e9todo para el diagn\u00f3stico del c\u00e1ncer de mama");
        MetadatumDTO subject = this.createMetadatumDTO("dc", "subject", null, "G01N  33/   574            A I                    ");
        metadatums.add(identifierOther);
        metadatums.add(identifier);
        metadatums.add(date);
        metadatums.add(dateSubmitted);
        metadatums.add(applicant);
        metadatums.add(applicant2);
        metadatums.add(author);
        metadatums.add(author2);
        metadatums.add(author3);
        metadatums.add(author4);
        metadatums.add(title);
        metadatums.add(subject);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO identifierOther2 = this.createMetadatumDTO("dc", "identifier", "other", "epodoc:TW202202864");
        MetadatumDTO identifier2 = this.createMetadatumDTO("dc", "identifier", null, "109122801");
        MetadatumDTO date2 = this.createMetadatumDTO("dc", "date", "issued", "2022-01-16");
        MetadatumDTO dateSubmitted2 = this.createMetadatumDTO("dc", "date", "submitted", "2020-01-06");
        MetadatumDTO applicant3 = this.createMetadatumDTO("dc", "contributor", null, "ADVANTEST CORP\u2002[JP]");
        MetadatumDTO applicant4 = this.createMetadatumDTO("dc", "contributor", null, "ADVANTEST CORPORATION");
        MetadatumDTO author5 = this.createMetadatumDTO("dc", "contributor", "author", "POEPPE OLAF\u2002[DE]");
        MetadatumDTO author6 = this.createMetadatumDTO("dc", "contributor", "author", " HILLIGES KLAUS-DIETER\u2002[DE]");
        MetadatumDTO author7 = this.createMetadatumDTO("dc", "contributor", "author", " KRECH ALAN\u2002[US]");
        MetadatumDTO author8 = this.createMetadatumDTO("dc", "contributor", "author", "POEPPE, OLAF, ");
        MetadatumDTO author9 = this.createMetadatumDTO("dc", "contributor", "author", "HILLIGES, KLAUS-DIETER, ");
        MetadatumDTO author10 = this.createMetadatumDTO("dc", "contributor", "author", "KRECH, ALAN");
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "Automated test equipment for testing one or more devices under test, method for automated testing of one or more devices under test, and computer program using a buffer memory");
        MetadatumDTO subject2 = this.createMetadatumDTO("dc", "subject", null, "G01R  31/   319            A I                    ");
        MetadatumDTO subject3 = this.createMetadatumDTO("dc", "subject", null, "G01R  31/  3193            A I                    ");
        metadatums2.add(identifierOther2);
        metadatums2.add(identifier2);
        metadatums2.add(date2);
        metadatums2.add(dateSubmitted2);
        metadatums2.add(applicant3);
        metadatums2.add(applicant4);
        metadatums2.add(author5);
        metadatums2.add(author6);
        metadatums2.add(author7);
        metadatums2.add(author8);
        metadatums2.add(author9);
        metadatums2.add(author10);
        metadatums2.add(title2);
        metadatums2.add(subject2);
        metadatums2.add(subject3);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

