/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class InfoEndpointIT
extends AbstractControllerIntegrationTest {
    private static final String INFO_PATH = "/actuator/info";
    @Autowired
    private ConfigurationService configurationService;

    @Test
    public void testWithAnonymousUser() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)INFO_PATH, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testWithNotAdminUser() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)INFO_PATH, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testWithAdminUser() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)INFO_PATH, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.name", this.matchProperty("dspace.name"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.dir", this.matchProperty("dspace.dir"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.url", this.matchProperty("dspace.server.url"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.db", this.matchProperty("db.url"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.solr.server", this.matchProperty("solr.server"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.solr.prefix", this.matchProperty("solr.multicorePrefix"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.mail.server", this.matchProperty("mail.server"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.mail.from-address", this.matchProperty("mail.from.address"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.mail.feedback-recipient", this.matchProperty("feedback.recipient"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.mail.mail-admin", this.matchProperty("mail.admin"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.mail.mail-helpdesk", this.matchProperty("mail.helpdesk"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.mail.alert-recipient", this.matchProperty("alert.recipient"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.cors.allowed-origins", this.matchProperty("rest.cors.allowed-origins"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.app.ui.url", this.matchProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.java", (Object[])new Object[0]).exists());
    }

    private Matcher<?> matchProperty(String name) {
        return Matchers.is((Object)this.configurationService.getProperty(name));
    }
}

