/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ItemOwningCollectionUpdateRestControllerIT
extends AbstractControllerIntegrationTest {
    @Test
    public void moveItemTestByAnonymous() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void moveItemTestByAuthorizedUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntry(col2.getName(), col2.getID(), col2.getHandle()))));
    }

    @Test
    public void moveItemTestByMinimallyAuthorizedUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        EPerson itemMoveEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("item@move.org").withPassword("test").withNameInMetadata("Item", "Move").build();
        ResourcePolicy rp1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(11).withDspaceObject((DSpaceObject)col1).build();
        ResourcePolicy rp2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicy rp3 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(3).withDspaceObject((DSpaceObject)col2).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(itemMoveEperson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(CollectionMatcher.matchCollectionEntry(col2.getName(), col2.getID(), col2.getHandle()))));
    }

    @Test
    public void moveItemTestByAuthorizedUserWithoutAdd() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        EPerson itemMoveEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("item@move.org").withPassword("test").withNameInMetadata("Item", "Move").build();
        ResourcePolicy rp1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(11).withDspaceObject((DSpaceObject)col1).build();
        ResourcePolicy rp2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(itemMoveEperson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void moveItemTestByAuthorizedUserWithoutAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        EPerson itemMoveEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("item@move.org").withPassword("test").withNameInMetadata("Item", "Move").build();
        ResourcePolicy rp2 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(1).withDspaceObject((DSpaceObject)publicItem1).build();
        ResourcePolicy rp3 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(3).withDspaceObject((DSpaceObject)col2).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(itemMoveEperson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void moveItemTestByAuthorizedUserWithoutWrite() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        EPerson itemMoveEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("item@move.org").withPassword("test").withNameInMetadata("Item", "Move").build();
        ResourcePolicy rp1 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(11).withDspaceObject((DSpaceObject)col1).build();
        ResourcePolicy rp3 = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)itemMoveEperson, null).withAction(3).withDspaceObject((DSpaceObject)col2).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(itemMoveEperson.getEmail(), "test");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void moveItemForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2019-10-21").withAuthor("Smith, Donald").build();
        this.context.restoreAuthSystemState();
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.put((String)("/api/core/items/" + publicItem1.getID() + "/owningCollection/"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/spring-rest/api/core/collections/" + col2.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }
}

