/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authenticate.OidcAuthenticationBean;
import org.dspace.authenticate.oidc.OidcClient;
import org.dspace.authenticate.oidc.OidcClientException;
import org.dspace.authenticate.oidc.model.OidcTokenResponseDTO;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.dspace.util.UUIDUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OidcAuthenticationRestControllerIT
extends AbstractControllerIntegrationTest {
    private static final String CODE = "123456";
    private static final String EMAIL = "email";
    private static final String FIRST_NAME = "first_name";
    private static final String LAST_NAME = "last_name";
    private static final String ACCESS_TOKEN = "c41e37e5-c2de-4177-91d6-ed9e9d1f31bf";
    private static final String REFRESH_TOKEN = "0062a9eb-d4ec-4d94-9491-95dd75376d3e";
    private static final String[] OIDC_SCOPES = new String[]{"FirstScope", "SecondScope"};
    private OidcClient originalOidcClient;
    private OidcClient oidcClientMock = (OidcClient)Mockito.mock(OidcClient.class);
    private EPerson createdEperson;
    @Autowired
    private OidcAuthenticationBean oidcAuthentication;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonService ePersonService;

    @Before
    public void setup() {
        this.originalOidcClient = this.oidcAuthentication.getOidcClient();
        this.oidcAuthentication.setOidcClient(this.oidcClientMock);
        this.configurationService.setProperty("authentication-oidc.user-info.email", (Object)EMAIL);
        this.configurationService.setProperty("authentication-oidc.user-info.first-name", (Object)FIRST_NAME);
        this.configurationService.setProperty("authentication-oidc.user-info.last-name", (Object)LAST_NAME);
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", Arrays.asList("org.dspace.authenticate.OidcAuthentication", "org.dspace.authenticate.PasswordAuthentication"));
    }

    @After
    public void after() throws Exception {
        this.oidcAuthentication.setOidcClient(this.originalOidcClient);
        if (this.createdEperson != null) {
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)this.createdEperson);
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void testEPersonCreationViaOidcLogin() throws Exception {
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOidcTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.oidcClientMock.getUserInfo(ACCESS_TOKEN)).thenReturn(this.buildUserInfo("test@email.it", "Test", "User"));
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn();
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getUserInfo(ACCESS_TOKEN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        this.createdEperson = (EPerson)this.ePersonService.find(this.context, UUIDUtils.fromString((String)ePersonId));
        MatcherAssert.assertThat((Object)this.createdEperson, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.createdEperson.getEmail(), (Matcher)Matchers.equalTo((Object)"test@email.it"));
        MatcherAssert.assertThat((Object)this.createdEperson.getFullName(), (Matcher)Matchers.equalTo((Object)"Test User"));
        MatcherAssert.assertThat((Object)this.createdEperson.getNetid(), (Matcher)Matchers.equalTo((Object)"test@email.it"));
        MatcherAssert.assertThat((Object)this.createdEperson.canLogIn(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testEPersonCreationViaOidcLoginWithoutEmail() throws Exception {
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOidcTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.oidcClientMock.getUserInfo(ACCESS_TOKEN)).thenReturn(this.buildUserInfo("test@email.it"));
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn();
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getUserInfo(ACCESS_TOKEN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        this.createdEperson = (EPerson)this.ePersonService.find(this.context, UUIDUtils.fromString((String)ePersonId));
        MatcherAssert.assertThat((Object)this.createdEperson, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testWithoutSelfRegistrationEnabled() throws Exception {
        this.configurationService.setProperty("authentication-oidc.can-self-register", (Object)"false");
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOidcTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.oidcClientMock.getUserInfo(ACCESS_TOKEN)).thenReturn(this.buildUserInfo("test@email.it"));
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andExpect(MockMvcResultMatchers.header().exists("WWW-Authenticate")).andReturn();
        String authenticateHeader = mvcResult.getResponse().getHeader("WWW-Authenticate");
        MatcherAssert.assertThat((Object)authenticateHeader, (Matcher)Matchers.containsString((String)"oidc realm=\"DSpace REST API\""));
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getUserInfo(ACCESS_TOKEN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
    }

    @Test
    public void testWithoutAuthorizationCode() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andExpect(MockMvcResultMatchers.header().exists("WWW-Authenticate"));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.oidcClientMock});
    }

    @Test
    public void testEPersonLoggedInByEmail() throws Exception {
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOidcTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.oidcClientMock.getUserInfo(ACCESS_TOKEN)).thenReturn(this.buildUserInfo("test@email.it"));
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        MvcResult mvcResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)this.configurationService.getProperty("dspace.ui.url"))).andExpect(MockMvcResultMatchers.cookie().exists("Authorization-cookie")).andReturn();
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getUserInfo(ACCESS_TOKEN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
        String ePersonId = this.getEPersonIdFromAuthorizationCookie(mvcResult);
        MatcherAssert.assertThat((Object)ePersonId, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ePersonId, (Matcher)Matchers.equalTo((Object)ePerson.getID().toString()));
    }

    @Test
    public void testEPersonCannotLogInByEmail() throws Exception {
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOidcTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.oidcClientMock.getUserInfo(ACCESS_TOKEN)).thenReturn(this.buildUserInfo("test@email.it"));
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andExpect(MockMvcResultMatchers.header().exists("WWW-Authenticate"));
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getUserInfo(ACCESS_TOKEN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
    }

    @Test
    public void testNoAuthenticationIfAnErrorOccursRetrivingOidcToken() throws Exception {
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenThrow(new Throwable[]{new OidcClientException(500, "internal error")});
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andExpect(MockMvcResultMatchers.header().exists("WWW-Authenticate"));
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
    }

    @Test
    public void testNoAuthenticationIfAnErrorOccursRetrivingOidcPerson() throws Exception {
        Mockito.when((Object)this.oidcClientMock.getAccessToken(CODE)).thenReturn((Object)this.buildOidcTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.oidcClientMock.getUserInfo(ACCESS_TOKEN)).thenThrow(new Throwable[]{new OidcClientException(500, "Internal Error")});
        this.context.turnOffAuthorisationSystem();
        EPersonBuilder.createEPerson((Context)this.context).withEmail("test@email.it").withNameInMetadata("Test", "User").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/oidc", (Object[])new Object[0]).param("code", new String[]{CODE})).andExpect(MockMvcResultMatchers.status().isUnauthorized()).andExpect(MockMvcResultMatchers.cookie().doesNotExist("Authorization-cookie")).andExpect(MockMvcResultMatchers.header().exists("WWW-Authenticate"));
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getAccessToken(CODE);
        ((OidcClient)Mockito.verify((Object)this.oidcClientMock)).getUserInfo(ACCESS_TOKEN);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oidcClientMock});
    }

    private OidcTokenResponseDTO buildOidcTokenResponse(String accessToken) {
        OidcTokenResponseDTO token = new OidcTokenResponseDTO();
        token.setAccessToken(accessToken);
        token.setTokenType("Bearer");
        token.setRefreshToken(REFRESH_TOKEN);
        token.setScope(String.join((CharSequence)" ", OIDC_SCOPES));
        return token;
    }

    private Map<String, Object> buildUserInfo(String email) {
        return Map.of(EMAIL, email);
    }

    private Map<String, Object> buildUserInfo(String email, String firstName, String lastName) {
        return Map.of(EMAIL, email, FIRST_NAME, firstName, LAST_NAME, lastName);
    }

    private String getEPersonIdFromAuthorizationCookie(MvcResult mvcResult) throws ParseException, JOSEException {
        Cookie authorizationCookie = mvcResult.getResponse().getCookie("Authorization-cookie");
        SignedJWT jwt = SignedJWT.parse((String)authorizationCookie.getValue());
        return (String)jwt.getJWTClaimsSet().getClaim("eid");
    }
}

