/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.pubmedeurope.PubmedEuropeMetadataSourceServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class PubmedEuropeMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private PubmedEuropeMetadataSourceServiceImpl pubmedEuropeMetadataServiceImpl;
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pubmedEuropeImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        InputStream file = null;
        InputStream file2 = null;
        try {
            file = ((Object)((Object)this)).getClass().getResourceAsStream("pubmedeurope-test.xml");
            file2 = ((Object)((Object)this)).getClass().getResourceAsStream("pubmedeurope-empty.xml");
            String pubmedEuropeXmlResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            String pubmedEuropeXmlResp2 = IOUtils.toString((InputStream)file2, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(pubmedEuropeXmlResp, 200, "OK");
            CloseableHttpResponse response2 = this.mockResponse(pubmedEuropeXmlResp2, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response, (Object[])new CloseableHttpResponse[]{response2});
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.pubmedEuropeMetadataServiceImpl.getRecords("test query", 0, 3);
            Assert.assertEquals((long)3L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
            if (Objects.nonNull(file)) {
                file.close();
            }
            if (Objects.nonNull(file2)) {
                file2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pubmedEuropeImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("pubmedeurope-test.xml");){
            String pubmedEuropeXmlResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(pubmedEuropeXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.pubmedEuropeMetadataServiceImpl.getRecordsCount("test query");
            Assert.assertEquals((long)3L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "First record of preserved soft parts in a Palaeozoic podocopid (Metacopina) ostracod, Cytherellina submagna: phylogenetic implications.");
        MetadatumDTO contributor = this.createMetadatumDTO("dc", "contributor", "author", "Olempska E");
        MetadatumDTO contributor2 = this.createMetadatumDTO("dc", "contributor", "author", "Horne DJ");
        MetadatumDTO contributor3 = this.createMetadatumDTO("dc", "contributor", "author", "Szaniawski H");
        MetadatumDTO doi = this.createMetadatumDTO("dc", "identifier", null, "10.1098/rspb.2011.0943");
        MetadatumDTO source = this.createMetadatumDTO("dc", "source", null, "Proceedings. Biological sciences");
        MetadatumDTO date = this.createMetadatumDTO("dc", "date", "issued", "2012");
        MetadatumDTO language = this.createMetadatumDTO("dc", "language", "iso", "eng");
        MetadatumDTO type = this.createMetadatumDTO("dc", "type", null, "Research Support, Non-U.S. Gov't");
        MetadatumDTO type2 = this.createMetadatumDTO("dc", "type", null, "research-article");
        MetadatumDTO type3 = this.createMetadatumDTO("dc", "type", null, "Journal Article");
        MetadatumDTO issn = this.createMetadatumDTO("dc", "identifier", "issn", "0962-8452");
        MetadatumDTO pmid = this.createMetadatumDTO("dc", "identifier", "other", "21733903");
        MetadatumDTO description = this.createMetadatumDTO("dc", "description", "abstract", "The metacopines represent one of the oldest and most important extinct groups of ostracods, with a fossil record from the Mid-Ordovician to the Early Jurassic. Herein, we report the discovery of a representative of the group with three-dimensionally preserved soft parts. The specimen--a male of Cytherellina submagna--was found in the Early Devonian (416 Ma) of Podolia, Ukraine. A branchial plate (Bp) of the cephalic maxillula (Mx), a pair of thoracic appendages (walking legs), a presumed furca (Fu) and a copulatory organ are preserved. The material also includes phosphatized steinkerns with exceptionally preserved marginal pore canals and muscle scars. The morphology of the preserved limbs and valves of C. submagna suggests its relationship with extant Podocopida, particularly with the superfamilies Darwinuloidea and Sigillioidea, which have many similar characteristic features, including a large Bp on the Mx, the morphology of walking legs, Fu with two terminal claws, internal stop-teeth in the left valve, adductor muscle scar pattern, and a very narrow fused zone along the anterior and posterior margins. More precise determination of affinities will depend on the soft-part morphology of the cephalic segment, which has not been revealed in the present material.");
        metadatums.add(doi);
        metadatums.add(title);
        metadatums.add(contributor);
        metadatums.add(contributor2);
        metadatums.add(contributor3);
        metadatums.add(source);
        metadatums.add(date);
        metadatums.add(language);
        metadatums.add(type);
        metadatums.add(type2);
        metadatums.add(type3);
        metadatums.add(description);
        metadatums.add(issn);
        metadatums.add(pmid);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "VODKA SYNEVIR");
        MetadatumDTO contributor4 = this.createMetadatumDTO("dc", "contributor", "author", "BARANOV VALENTYN VOLODYMYROVYC");
        MetadatumDTO contributor5 = this.createMetadatumDTO("dc", "contributor", "author", "DANCHAK ROMAN ADAMOVYCH");
        MetadatumDTO contributor6 = this.createMetadatumDTO("dc", "contributor", "author", "FEDORCHUK NATALIIA HRYHORIVNA");
        MetadatumDTO contributor7 = this.createMetadatumDTO("dc", "contributor", "author", "FEDOREIKO LIUBOV ROMANIVNA");
        MetadatumDTO language2 = this.createMetadatumDTO("dc", "language", "iso", "eng");
        MetadatumDTO type4 = this.createMetadatumDTO("dc", "type", null, "Patent");
        MetadatumDTO pmid2 = this.createMetadatumDTO("dc", "identifier", "other", "UA37818");
        MetadatumDTO description2 = this.createMetadatumDTO("dc", "description", "abstract", "Vodka contains aqueous-alcoholic mixture, 65.8 % sugar syrup and apple vinegar. As a result the vodka has light taste without vodka acid and light apple aroma.");
        metadatums2.add(title2);
        metadatums2.add(contributor4);
        metadatums2.add(contributor5);
        metadatums2.add(contributor6);
        metadatums2.add(contributor7);
        metadatums2.add(language2);
        metadatums2.add(type4);
        metadatums2.add(description2);
        metadatums2.add(pmid2);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        ArrayList<MetadatumDTO> metadatums3 = new ArrayList<MetadatumDTO>();
        MetadatumDTO title3 = this.createMetadatumDTO("dc", "title", null, "A VODKA CHARKA");
        MetadatumDTO contributor8 = this.createMetadatumDTO("dc", "contributor", "author", "BARANOV VALENTYN VOLODYMYROVYC");
        MetadatumDTO contributor9 = this.createMetadatumDTO("dc", "contributor", "author", "DANCHAK ROMAN ADAMOVYCH");
        MetadatumDTO contributor10 = this.createMetadatumDTO("dc", "contributor", "author", "FEDORCHUK NATALIIA HRYHORIVNA");
        MetadatumDTO contributor11 = this.createMetadatumDTO("dc", "contributor", "author", "FEDOREIKO LIUBOV ROMANIVNA");
        MetadatumDTO language3 = this.createMetadatumDTO("dc", "language", "iso", "eng");
        MetadatumDTO type5 = this.createMetadatumDTO("dc", "type", null, "Patent");
        MetadatumDTO pmid3 = this.createMetadatumDTO("dc", "identifier", "other", "UA37954");
        MetadatumDTO description3 = this.createMetadatumDTO("dc", "description", "abstract", "The invention relates to food industry, and particularly to liqueur and vodka industry, to vodkas compositions. The aim of this invention is producing vodka with high organoleptic indices, and particularly soft taste without vodka bitterness and without vodka aroma, and high biological properties, by selection of necessary ingredients at required quantities. Ingredients ratio at 100 l of finished drink: Carbohydrate module \u00f4Alkosoft\u00f6, l 0.07-0.13Citric oil, kg 0,0015-0,0025 Aqueous-alcoholic mixture as calculated per strength of 40% of volume rest. Technical result - preparation of the vodka of given composition with a strength of 40% of volume, which is transparent, colorless, has mild taste without vodka bitterness and without strong vodka aroma which will not cause alcohol withdrawal syndrome and high charge on the body.");
        metadatums3.add(title3);
        metadatums3.add(contributor8);
        metadatums3.add(contributor9);
        metadatums3.add(contributor10);
        metadatums3.add(contributor11);
        metadatums3.add(language3);
        metadatums3.add(type5);
        metadatums3.add(description3);
        metadatums3.add(pmid3);
        ImportRecord thirdRecord = new ImportRecord(metadatums3);
        records.add(firstrRecord);
        records.add(secondRecord);
        records.add(thirdRecord);
        return records;
    }
}

