/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.matcher.BundleMatcher;
import org.dspace.app.rest.matcher.CommunityMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SubResourcePermissionsIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizeService authorizeService;

    @Test
    public void itemBundlePrivateItemPermissionTest() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item privateItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)privateItem1, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)privateItem1).withName("testname").withBitstream(bitstream).build();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)privateItem1);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + privateItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType()))));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + privateItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + privateItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + privateItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType()))));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + privateItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + privateItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())));
    }

    @Test
    public void itemBundlePrivateBundlePermissionTest() throws Exception {
        Bitstream bitstream;
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)CharEncoding.UTF_8);){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publicItem1, (InputStream)is).withName("Bitstream").withMimeType("text/plain").build();
        }
        Bundle bundle = BundleBuilder.createBundle((Context)this.context, (Item)publicItem1).withName("testname").withBitstream(bitstream).build();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bundle);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType()))));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Matcher)Matchers.not((Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID() + "/bundles"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles", (Matcher)Matchers.not((Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())))));
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType()))));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.not((Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.bundles._embedded.bundles", (Matcher)Matchers.not((Matcher)Matchers.hasItem(BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())))));
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", BundleMatcher.matchProperties(bundle.getName(), bundle.getID(), bundle.getHandle(), bundle.getType())));
        token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bundles/" + bundle.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void parentCommunityOfPrivateCollectionPermissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)col1);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/community/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/community/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/community/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void privateParentCommunityOfCollectionPermissionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)this.parentCommunity);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID() + "/parentCommunity"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/community/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/community/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/community/" + this.parentCommunity.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", CommunityMatcher.matchCommunityEntry(this.parentCommunity.getID(), this.parentCommunity.getHandle())));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", (Object[])new Object[0]).doesNotExist());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/collections/" + col1.getID()), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parentCommunity", (Object[])new Object[0]).doesNotExist());
    }
}

