/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.SupervisionOrderMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SupervisionOrderBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.InstallItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.supervision.service.SupervisionOrderService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SupervisionOrderRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SupervisionOrderService supervisionOrderService;
    @Autowired
    private InstallItemService installItemService;

    @Before
    public void init() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllByAnonymousUserTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllByNotAdminUserTest() throws Exception {
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllByAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.admin).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(this.eperson).build();
        SupervisionOrder supervisionOrderOne = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)groupA).build();
        SupervisionOrder supervisionOrderTwo = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)groupB).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.supervisionorders", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SupervisionOrderMatcher.matchSuperVisionOrder(supervisionOrderOne), SupervisionOrderMatcher.matchSuperVisionOrder(supervisionOrderTwo)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/supervisionorders")));
    }

    @Test
    public void findOneByAnonymousUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneByNotAdminUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneByAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SupervisionOrderMatcher.matchSuperVisionOrder(supervisionOrder)));
    }

    @Test
    public void findOneByAdminButNotFoundTest() throws Exception {
        int fakeId = 12354326;
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + fakeId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findByItemByAnonymousUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/search/byItem", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByItemByNotAdminUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/search/byItem", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByItemByAdminButNotFoundItemTest() throws Exception {
        String fakeItemId = "d9dcf4c3-093d-413e-a538-93d8589d3ea6";
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/search/byItem", (Object[])new Object[0]).param("uuid", new String[]{fakeItemId})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findByItemByAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item itemOne = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.admin).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(this.eperson).build();
        SupervisionOrder supervisionOrderOne = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)itemOne, (Group)groupA).build();
        SupervisionOrder supervisionOrderTwo = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)itemOne, (Group)groupB).build();
        Item itemTwo = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item two title").build();
        SupervisionOrder supervisionOrderItemTwo = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)itemTwo, (Group)groupA).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/search/byItem", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.supervisionorders", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{SupervisionOrderMatcher.matchSuperVisionOrder(supervisionOrderOne), SupervisionOrderMatcher.matchSuperVisionOrder(supervisionOrderTwo)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/supervisionorders/search/byItem?uuid=" + itemOne.getID()))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/supervisionorders/search/byItem", (Object[])new Object[0]).param("uuid", new String[]{itemTwo.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.supervisionorders", (Matcher)Matchers.contains(SupervisionOrderMatcher.matchSuperVisionOrder(supervisionOrderItemTwo)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/supervisionorders/search/byItem?uuid=" + itemTwo.getID()))));
    }

    @Test
    public void createByAnonymousUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{group.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createByNotAdminUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{group.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createByAdminButMissingParametersTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item itemOne = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createByAdminButIncorrectTypeParameterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{group.getID().toString()}).param("type", new String[]{"WRONG"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void createByAdminButNotFoundItemOrGroupTest() throws Exception {
        String fakeItemId = "d9dcf4c3-093d-413e-a538-93d8589d3ea6";
        String fakeGroupId = "d9dcf4c3-093d-413e-a538-93d8589d3ea6";
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item itemOne = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{fakeItemId}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{fakeGroupId}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createTheSameSupervisionOrderTwiceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)col1).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").grantLicense().build();
        Item itemOne = workspaceItem.getItem();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"OBSERVER"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createSupervisionOrderOnArchivedItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item itemOne = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").withIssueDate("2017-10-17").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"OBSERVER"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createByAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson userA = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("test1@email.com").withPassword(this.password).build();
        EPerson userB = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("test2@email.com").withPassword(this.password).build();
        EPerson userC = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("test3@email.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection publications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Publications").withEntityType("Publication").build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)publications).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).grantLicense().build();
        Item itemOne = witem.getItem();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(userB).build();
        Group groupC = GroupBuilder.createGroup((Context)this.context).withName("group C").addMember(userC).build();
        this.context.restoreAuthSystemState();
        AtomicInteger supervisionOrderIdOne = new AtomicInteger();
        AtomicInteger supervisionOrderIdTwo = new AtomicInteger();
        AtomicInteger supervisionOrderIdThree = new AtomicInteger();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> supervisionOrderIdOne.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupB.getID().toString()}).param("type", new String[]{"OBSERVER"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> supervisionOrderIdTwo.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{itemOne.getID().toString()}).param("group", new String[]{groupC.getID().toString()}).param("type", new String[]{"NONE"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> supervisionOrderIdThree.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        SupervisionOrder supervisionOrderOne = (SupervisionOrder)this.supervisionOrderService.find(this.context, supervisionOrderIdOne.get());
        SupervisionOrder supervisionOrderTwo = (SupervisionOrder)this.supervisionOrderService.find(this.context, supervisionOrderIdTwo.get());
        SupervisionOrder supervisionOrderThree = (SupervisionOrder)this.supervisionOrderService.find(this.context, supervisionOrderIdThree.get());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrderOne.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SupervisionOrderMatcher.matchSuperVisionOrder((SupervisionOrder)this.context.reloadEntity((ReloadableEntity)supervisionOrderOne))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrderTwo.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SupervisionOrderMatcher.matchSuperVisionOrder((SupervisionOrder)this.context.reloadEntity((ReloadableEntity)supervisionOrderTwo))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrderThree.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SupervisionOrderMatcher.matchSuperVisionOrder((SupervisionOrder)this.context.reloadEntity((ReloadableEntity)supervisionOrderThree))));
        String authTokenA = this.getAuthToken(userA.getEmail(), this.password);
        String authTokenB = this.getAuthToken(userB.getEmail(), this.password);
        String authTokenC = this.getAuthToken(userC.getEmail(), this.password);
        String patchBody = this.getPatchContent(List.of(new ReplaceOperation("/sections/traditionalpageone/dc.title/0", Map.of("value", "New Title"))));
        this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authTokenC).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authTokenB).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authTokenC).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteByAnonymousUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteByNotAdminUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteByAdminButNotFoundTest() throws Exception {
        int fakeId = 12354326;
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/supervisionorders/" + fakeId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteByAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String patchBody = this.getPatchContent(List.of(new ReplaceOperation("/withdrawn", (Object)true)));
        this.getClient(this.getAuthToken(this.eperson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        Assert.assertTrue((boolean)item.getResourcePolicies().stream().noneMatch(rp -> group.getID().equals(rp.getGroup().getID())));
    }

    @Test
    public void deleteItemThenSupervisionOrderBeDeletedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteGroupThenSupervisionOrderBeDeletedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("item title").build();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
        SupervisionOrder supervisionOrder = SupervisionOrderBuilder.createSupervisionOrder((Context)this.context, (Item)item, (Group)group).build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + supervisionOrder.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteWorkspaceItemThenSupervisionOrderIsDeletedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection publications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Publications").withEntityType("Publication").build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(this.eperson).build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)publications).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").grantLicense().build();
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{witem.getItem().getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void installWorkspaceItemThenSupervisionOrderIsDeletedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection publications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Publications").withEntityType("Publication").build();
        EPerson userA = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("test1@email.com").withPassword(this.password).build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(this.eperson).build();
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)publications).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").grantLicense().build();
        this.context.restoreAuthSystemState();
        AtomicReference idRefOne = new AtomicReference();
        AtomicReference idRefTwo = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{witem.getItem().getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRefOne.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{witem.getItem().getID().toString()}).param("group", new String[]{groupB.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRefTwo.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + idRefOne.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + idRefTwo.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.context.turnOffAuthorisationSystem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.context.reloadEntity((ReloadableEntity)witem));
        this.context.restoreAuthSystemState();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + idRefOne.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/supervisionorders/" + idRefTwo.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void createOnArchivedAndWithdrawnItemsNotAllowedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection publications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Publications").withEntityType("Publication").build();
        EPerson userA = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("test1@email.com").withPassword(this.password).build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup((Context)this.context).withName("group B").addMember(this.eperson).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)publications).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").grantLicense().build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{groupB.getID().toString()}).param("type", new String[]{"OBSERVER"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        String patchBody = this.getPatchContent(List.of(new ReplaceOperation("/withdrawn", (Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + item.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{item.getID().toString()}).param("group", new String[]{groupB.getID().toString()}).param("type", new String[]{"OBSERVER"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSupervisionOnWorkspaceThenSubmitToWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup("reviewer", new EPerson[]{reviewer}).build();
        EPerson userA = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("userA@test.com").withPassword(this.password).build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(userA).build();
        InputStream pdf = ((Object)((Object)this)).getClass().getResourceAsStream("simple-article.pdf");
        WorkspaceItem witem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withTitle("Workspace Item 1").withIssueDate("2017-10-17").withSubject("ExtraEntry").withFulltext("simple-article.pdf", "/local/path/simple-article.pdf", pdf).grantLicense().build();
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{witem.getItem().getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        String authTokenA = this.getAuthToken(userA.getEmail(), this.password);
        String patchBody = this.getPatchContent(List.of(new ReplaceOperation("/sections/traditionalpageone/dc.title/0", Map.of("value", "New Title"))));
        this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + witem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.errors", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "New Title", "2017-10-17", "ExtraEntry"))));
        AtomicReference idRef = new AtomicReference();
        try {
            String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
            String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + witem.getID()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "New Title", "2017-10-17")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.discoverable", (Matcher)Matchers.is((Object)true)));
            this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/workflowitems/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssued(null, "New Title", "2017-10-17")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.defaultAC.discoverable", (Matcher)Matchers.is((Object)true)));
            String patchBodyTwo = this.getPatchContent(List.of(new ReplaceOperation("/metadata/dc.title", Map.of("value", "edited title"))));
            this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + witem.getItem().getID()), (Object[])new Object[0]).content(patchBodyTwo).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + idRef.get()), (Object[])new Object[0]).content(patchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            if (idRef.get() != null) {
                WorkflowItemBuilder.deleteWorkflowItem((Integer)((Integer)idRef.get()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void supervisionOrderAddedToWorkflowItemThenSentBackToWorkspace() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withWorkflowGroup("reviewer", new EPerson[]{this.admin}).build();
        XmlWorkflowItem workflowItem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)collection).withSubmitter(this.admin).withTitle("this is the title").withIssueDate("1982-12-17").grantLicense().build();
        EPerson userA = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("userA@test.com").withPassword(this.password).build();
        Group groupA = GroupBuilder.createGroup((Context)this.context).withName("group A").addMember(userA).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/supervisionorders/", (Object[])new Object[0]).param("uuid", new String[]{workflowItem.getItem().getID().toString()}).param("group", new String[]{groupA.getID().toString()}).param("type", new String[]{"EDITOR"}).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        String workflowItemPatchBody = this.getPatchContent(List.of(new ReplaceOperation("/metadata/dc.title", Map.of("value", "edited title"))));
        String authTokenA = this.getAuthToken(userA.getEmail(), this.password);
        this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + workflowItem.getItem().getID()), (Object[])new Object[0]).content(workflowItemPatchBody).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        AtomicReference idRef = new AtomicReference();
        try {
            String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/workflowitems/" + workflowItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.workspaceitems[0].id", (Predicate[])new Predicate[0])));
            String workspaceItemPatchBody = this.getPatchContent(List.of(new ReplaceOperation("/sections/traditionalpageone/dc.title/0", Map.of("value", "New Title"))));
            this.getClient(authTokenA).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + idRef.get()), (Object[])new Object[0]).content(workspaceItemPatchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        }
        finally {
            Integer id = (Integer)idRef.get();
            if (Objects.nonNull(id)) {
                WorkspaceItemBuilder.deleteWorkspaceItem((Integer)id);
            }
        }
    }
}

