/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.matcher.WorkflowActionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.GroupBuilder;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.state.actions.processingaction.ScoreReviewActionAdvancedInfo;
import org.dspace.xmlworkflow.state.actions.processingaction.SelectReviewerAction;
import org.dspace.xmlworkflow.state.actions.processingaction.SelectReviewerActionAdvancedInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class WorkflowActionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private static final String WORKFLOW_ACTIONS_ENDPOINT = "/api/config/workflowactions";

    @Test
    public void getAllWorkflowActions_NonImplementedEndpoint() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_ACTIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void getAllWorkflowActions_NonImplementedEndpoint_NonValidToken() throws Exception {
        String token = "nonValidToken";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_ACTIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getAllWorkflowActions_NonImplementedEndpoint_NoToken() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_ACTIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowActionByName_NonExistentWorkflowAction() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameNonExistentWorkflowActionName = "TestNameNonExistentWorkflowAction9999";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameNonExistentWorkflowActionName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getWorkflowActionByName_ExistentWithOptions_editaction() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameActionWithOptions = "editaction";
        WorkflowActionConfig existentWorkflow = this.xmlWorkflowFactory.getActionByName(nameActionWithOptions);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameActionWithOptions), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.options", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advanced", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(WorkflowActionMatcher.matchWorkflowActionEntry(existentWorkflow))));
    }

    @Test
    public void getWorkflowActionByName_ExistentWithoutOptions_claimaction() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameActionWithoutOptions = "claimaction";
        WorkflowActionConfig existentWorkflowNoOptions = this.xmlWorkflowFactory.getActionByName(nameActionWithoutOptions);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameActionWithoutOptions), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.options", (Matcher)Matchers.empty())).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advanced", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(WorkflowActionMatcher.matchWorkflowActionEntry(existentWorkflowNoOptions))));
    }

    @Test
    public void getWorkflowActionByName_ExistentWithOptions_NonValidToken() throws Exception {
        String token = "nonValidToken";
        String nameActionWithOptions = "editaction";
        WorkflowActionConfig existentWorkflow = this.xmlWorkflowFactory.getActionByName(nameActionWithOptions);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameActionWithOptions), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowActionByName_ExistentWithOptions_NoToken() throws Exception {
        String nameActionWithOptions = "editaction";
        WorkflowActionConfig existentWorkflow = this.xmlWorkflowFactory.getActionByName(nameActionWithOptions);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameActionWithOptions), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowActionByName_ExistentWithOptions_ratingreviewaction() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameActionWithOptions = "scorereviewaction";
        WorkflowActionConfig existentWorkflow = this.xmlWorkflowFactory.getActionByName(nameActionWithOptions);
        ScoreReviewActionAdvancedInfo scoreReviewActionAdvancedInfo = new ScoreReviewActionAdvancedInfo();
        scoreReviewActionAdvancedInfo.setDescriptionRequired(true);
        scoreReviewActionAdvancedInfo.setMaxValue(5);
        scoreReviewActionAdvancedInfo.setType("submit_score");
        scoreReviewActionAdvancedInfo.generateId("submit_score");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameActionWithOptions), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.options", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advancedOptions", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advanced", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advancedInfo", (Matcher)Matchers.contains(WorkflowActionMatcher.matchScoreReviewActionAdvancedInfo(scoreReviewActionAdvancedInfo)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(WorkflowActionMatcher.matchWorkflowActionEntry(existentWorkflow))));
    }

    @Test
    public void getWorkflowActionByName_ExistentWithOptions_selectrevieweraction() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nameActionWithOptions = "selectrevieweraction";
        SelectReviewerAction.resetGroup();
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("ReviewersUUIDConfig").build();
        this.configurationService.setProperty("action.selectrevieweraction.group", (Object)group.getID());
        this.context.restoreAuthSystemState();
        SelectReviewerActionAdvancedInfo selectReviewerActionAdvancedInfo = new SelectReviewerActionAdvancedInfo();
        selectReviewerActionAdvancedInfo.setGroup(group.getID().toString());
        selectReviewerActionAdvancedInfo.setType("submit_select_reviewer");
        selectReviewerActionAdvancedInfo.generateId("submit_select_reviewer");
        WorkflowActionConfig existentWorkflow = this.xmlWorkflowFactory.getActionByName(nameActionWithOptions);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowactions/" + nameActionWithOptions), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.options", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advancedOptions", (Matcher)Matchers.not((Matcher)Matchers.empty()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advanced", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.advancedInfo", (Matcher)Matchers.contains(WorkflowActionMatcher.matchSelectReviewerActionAdvancedInfo(selectReviewerActionAdvancedInfo)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(WorkflowActionMatcher.matchWorkflowActionEntry(existentWorkflow))));
    }
}

