/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.util.concurrent.Callable;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EditItemFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private SiteService siteService;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private Utils utils;
    private Group group;
    private String siteUri;
    private String epersonToken;
    private AuthorizationFeature editItemFeature;
    private Community communityA;
    private Collection collectionA1;
    private Collection collectionA2;
    private Item itemA1X;
    private Item itemA2X;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.withSuppressedAuthorization(() -> {
            this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("Community A").build();
            this.collectionA1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("Collection A1").build();
            this.collectionA2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("Collection A2").build();
            this.itemA1X = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA1).withTitle("Item A1X").build();
            this.itemA2X = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA2).withTitle("Item A2X").build();
            this.group = GroupBuilder.createGroup((Context)this.context).withName("group").addMember(this.eperson).build();
            return null;
        });
        this.editItemFeature = this.authorizationFeatureService.find("canEditItem");
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        this.siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
    }

    @Test
    public void testNoRights() throws Exception {
        this.expectZeroResults(this.requestSitewideEditItemFeature());
    }

    @Test
    public void testDirectEPersonWritePolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.itemA1X).withAction(1).build();
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(this.itemA1X));
        this.expectZeroResults(this.requestEditItemFeature(this.itemA2X));
    }

    @Test
    public void testDirectGroupWritePolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.group).withDspaceObject((DSpaceObject)this.itemA1X).withAction(1).build();
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(this.itemA1X));
        this.expectZeroResults(this.requestEditItemFeature(this.itemA2X));
    }

    @Test
    public void testDirectEPersonAdminPolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.itemA1X).withAction(11).build();
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(this.itemA1X));
        this.expectZeroResults(this.requestEditItemFeature(this.itemA2X));
    }

    @Test
    public void testDirectGroupAdminPolicy() throws Exception {
        ResourcePolicy rp = ResourcePolicyBuilder.createResourcePolicy((Context)this.context, null, (Group)this.group).withDspaceObject((DSpaceObject)this.itemA1X).withAction(11).build();
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(this.itemA1X));
        this.expectZeroResults(this.requestEditItemFeature(this.itemA2X));
    }

    @Test
    public void testNonemptyCollectionAdmin() throws Exception {
        Item item = this.withSuppressedAuthorization(() -> {
            Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("nonempty collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            return ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("item in nonempty collection").build();
        });
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(item));
        this.expectZeroResults(this.requestEditItemFeature(this.itemA1X));
        this.expectZeroResults(this.requestEditItemFeature(this.itemA2X));
    }

    @Test
    public void testEmptyCollectionAdmin() throws Exception {
        this.withSuppressedAuthorization(() -> {
            Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("nonempty collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            return null;
        });
        this.expectZeroResults(this.requestSitewideEditItemFeature());
    }

    @Test
    public void testCommunityWithEmptyCollectionAdmin() throws Exception {
        this.withSuppressedAuthorization(() -> {
            Community comm = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains a collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            Collection coll = CollectionBuilder.createCollection((Context)this.context, (Community)comm).withName("This collection contains no items").build();
            return null;
        });
        this.expectZeroResults(this.requestSitewideEditItemFeature());
    }

    @Test
    public void testCommunityWithNonemptyCollectionAdmin() throws Exception {
        Item item = this.withSuppressedAuthorization(() -> {
            Community comm = CommunityBuilder.createCommunity((Context)this.context).withName("This community contains a collection").withAdminGroup(new EPerson[]{this.eperson}).build();
            Collection coll = CollectionBuilder.createCollection((Context)this.context, (Community)comm).withName("This collection contains an item").build();
            return ItemBuilder.createItem((Context)this.context, (Collection)coll).withTitle("This is an item").build();
        });
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(item));
    }

    @Test
    public void testNestedCommunitiesWithNonemptyCollectionAdmin() throws Exception {
        Item item = this.withSuppressedAuthorization(() -> {
            Community parent = CommunityBuilder.createCommunity((Context)this.context).withName("parent community").withAdminGroup(new EPerson[]{this.eperson}).build();
            Community child = CommunityBuilder.createSubCommunity((Context)this.context, (Community)parent).withName("child community").withAdminGroup(new EPerson[]{this.eperson}).build();
            Collection coll = CollectionBuilder.createCollection((Context)this.context, (Community)child).withName("This collection contains an item").build();
            return ItemBuilder.createItem((Context)this.context, (Collection)coll).withTitle("This is an item").build();
        });
        this.expectSomeResults(this.requestSitewideEditItemFeature());
        this.expectSomeResults(this.requestEditItemFeature(item));
    }

    private ResultActions requestSitewideEditItemFeature() throws Exception {
        return this.requestEditItemFeature(this.siteUri);
    }

    private ResultActions requestEditItemFeature(Item item) throws Exception {
        return this.requestEditItemFeature(this.getItemUri(item));
    }

    private ResultActions requestEditItemFeature(String uri) throws Exception {
        this.epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        return this.getClient(this.epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object?", (Object[])new Object[0]).param("uri", new String[]{uri}).param("feature", new String[]{this.editItemFeature.getName()}).param("embed", new String[]{"feature"}));
    }

    private ResultActions expectSomeResults(ResultActions actions) throws Exception {
        return actions.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    private ResultActions expectZeroResults(ResultActions actions) throws Exception {
        return actions.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    private <T> T withSuppressedAuthorization(Callable<T> fn) throws Exception {
        this.context.turnOffAuthorisationSystem();
        T result = fn.call();
        this.context.restoreAuthSystemState();
        return result;
    }

    private String getItemUri(Item item) {
        ItemRest itemRest = this.itemConverter.convert(item, DefaultProjection.DEFAULT);
        return this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
    }
}

