/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sword2;

import java.nio.file.Path;
import java.util.List;
import org.dspace.app.rest.test.AbstractWebClientIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.TestPropertySource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@TestPropertySource(properties={"swordv2-server.enabled = true"})
public class Swordv2IT
extends AbstractWebClientIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    private final String SWORD_PATH = "/swordv2";
    private final String SERVICE_DOC_PATH = "/swordv2/servicedocument";
    private final String COLLECTION_PATH = "/swordv2/collection";
    private final String MEDIA_RESOURCE_PATH = "/swordv2/edit-media";
    private final String EDIT_PATH = "/swordv2/edit";
    private final String STATEMENT_PATH = "/swordv2/statement";
    private final String ATOM_SERVICE_CONTENT_TYPE = "application/atomserv+xml;charset=UTF-8";
    private final String ATOM_FEED_CONTENT_TYPE = "application/atom+xml;type=feed;charset=UTF-8";
    private final String ATOM_ENTRY_CONTENT_TYPE = "application/atom+xml;type=entry;charset=UTF-8";
    @ClassRule
    public static final TemporaryFolder uploadTempFolder = new TemporaryFolder();

    @Before
    public void onlyRunIfConfigExists() {
        try {
            Class.forName("org.dspace.app.configuration.SWORDv2WebConfig");
        }
        catch (ClassNotFoundException ce) {
            Assume.assumeNoException((Throwable)ce);
        }
        this.configurationService.setProperty("swordv2-server.url", (Object)this.getURL("/swordv2"));
        this.configurationService.setProperty("swordv2-server.servicedocument.url", (Object)this.getURL("/swordv2/servicedocument"));
        this.configurationService.setProperty("swordv2-server.collection.url", (Object)this.getURL("/swordv2/collection"));
        this.configurationService.setProperty("swordv2-server.upload.tempdir", (Object)uploadTempFolder.getRoot().getAbsolutePath());
        this.configurationService.setProperty("plugin.single.org.dspace.sword2.WorkflowManager", (Object)"org.dspace.sword2.WorkflowManagerUnrestricted");
    }

    @Test
    public void serviceDocumentUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/servicedocument");
        Assert.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)response.getStatusCode());
    }

    @Test
    public void serviceDocumentTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/servicedocument", this.eperson.getEmail(), this.password);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        Assert.assertEquals((Object)"application/atomserv+xml;charset=UTF-8", (Object)response.getHeaders().getContentType().toString());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)"<version xmlns=\"http://purl.org/net/sword/terms/\">2.0</version>"));
    }

    @Test
    public void collectionUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/collection", null, null, null);
        Assert.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)response.getStatusCode());
    }

    @Test
    public void collectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test SWORDv2 Collection").build();
        String itemTitle = "Test SWORDv2 Item";
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle(itemTitle).withAuthor("Smith, Sam").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/collection/" + collection.getHandle(), this.eperson.getEmail(), this.password);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        Assert.assertEquals((Object)"application/atom+xml;type=feed;charset=UTF-8", (Object)response.getHeaders().getContentType().toString());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("/swordv2/edit/" + item.getID().toString())));
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("<title type=\"text\">" + itemTitle + "</title>")));
    }

    @Test
    public void mediaResourceUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/edit-media", null, null, null);
        Assert.assertEquals((Object)response.getStatusCode(), (Object)HttpStatus.UNAUTHORIZED);
    }

    @Test
    public void depositAndEditViaSwordTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test SWORDv2 Collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        LinkedMultiValueMap multipart = new LinkedMultiValueMap();
        multipart.add((Object)"file", (Object)new FileSystemResource(Path.of("src", "test", "resources", "org", "dspace", "app", "sword2", "example.zip")));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.setContentDisposition(ContentDisposition.attachment().filename("example.zip").build());
        headers.set("Packaging", "http://purl.org/net/sword/package/METSDSpaceSIP");
        headers.setAccept(List.of(MediaType.APPLICATION_ATOM_XML));
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/collection/" + collection.getHandle(), this.eperson.getEmail(), this.password, new HttpEntity((Object)multipart, (MultiValueMap)headers));
        Assert.assertEquals((Object)HttpStatus.CREATED, (Object)response.getStatusCode());
        Assert.assertEquals((Object)"application/atom+xml;type=entry;charset=UTF-8", (Object)response.getHeaders().getContentType().toString());
        Assert.assertNotNull((Object)response.getHeaders().getLocation());
        String editLink = response.getHeaders().getLocation().toString();
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("<link href=\"" + editLink + "\" rel=\"edit\"/>")));
        HttpHeaders authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        RequestEntity request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        Assert.assertEquals((Object)"application/atom+xml;type=feed;charset=UTF-8", (Object)response.getHeaders().getContentType().toString());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)this.getURL("/swordv2/edit-media/bitstream")));
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)"Attempts to detect retrotransposition"));
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.admin.getEmail(), this.password);
        String newTitle = "This is a new title updated via PUT";
        String newTitleEntry = "<entry xmlns=\"http://www.w3.org/2005/Atom\"><title>" + newTitle + "</title></entry>";
        request = ((RequestEntity.BodyBuilder)RequestEntity.put((String)editLink, (Object[])new Object[0]).headers(authHeaders)).contentType(MediaType.APPLICATION_ATOM_XML).body((Object)newTitleEntry);
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)newTitle));
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.admin.getEmail(), this.password);
        request = RequestEntity.delete((String)editLink, (Object[])new Object[0]).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.NO_CONTENT, (Object)response.getStatusCode());
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)response.getStatusCode());
    }

    @Test
    public void deleteWorkspaceItemViaSwordTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test SWORDv2 Collection").withSubmitterGroup(new EPerson[]{this.eperson}).build();
        String titleOfItem = "This is a test SWORD workspace item";
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle(titleOfItem).build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        String editLink = "/swordv2/edit/" + wsi.getItem().getID();
        HttpHeaders authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        RequestEntity request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        ResponseEntity<String> response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)titleOfItem));
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        request = RequestEntity.delete((String)editLink, (Object[])new Object[0]).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.NO_CONTENT, (Object)response.getStatusCode());
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)response.getStatusCode());
    }

    @Test
    public void deleteWorkflowItemViaSwordTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test SWORDv2 Workflow Collection").withSubmitterGroup(new EPerson[]{this.eperson}).withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        String titleOfItem = "This is a test SWORD workflow item";
        XmlWorkflowItem workflowItem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)collection).withSubmitter(this.eperson).withTitle(titleOfItem).withIssueDate("2017-10-17").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        String editLink = "/swordv2/edit/" + workflowItem.getItem().getID();
        HttpHeaders authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        RequestEntity request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        ResponseEntity<String> response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)titleOfItem));
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.admin.getEmail(), this.password);
        request = RequestEntity.delete((String)editLink, (Object[])new Object[0]).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.NO_CONTENT, (Object)response.getStatusCode());
        authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        request = RequestEntity.get((String)editLink, (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.NOT_FOUND, (Object)response.getStatusCode());
    }

    @Test
    public void editUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.postResponseAsString("/swordv2/edit", null, null, null);
        Assert.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)response.getStatusCode());
    }

    @Test
    public void statementUnauthorizedTest() throws Exception {
        ResponseEntity<String> response = this.getResponseAsString("/swordv2/statement");
        Assert.assertEquals((Object)HttpStatus.UNAUTHORIZED, (Object)response.getStatusCode());
    }

    @Test
    public void statementTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(this.eperson);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test SWORDv2 Collection").build();
        String itemTitle = "Test SWORDv2 Item";
        String itemAuthor = "Smith, Samantha";
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle(itemTitle).withAuthor(itemAuthor).build();
        this.context.commit();
        this.context.restoreAuthSystemState();
        HttpHeaders authHeaders = new HttpHeaders();
        authHeaders.setBasicAuth(this.eperson.getEmail(), this.password);
        RequestEntity request = RequestEntity.get((String)this.getURL("/swordv2/statement/" + item.getID().toString()), (Object[])new Object[0]).accept(new MediaType[]{MediaType.valueOf((String)"application/atom+xml")}).headers(authHeaders).build();
        ResponseEntity<String> response = this.responseAsString(request);
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        Assert.assertEquals((Object)"application/atom+xml;type=feed;charset=UTF-8", (Object)response.getHeaders().getContentType().toString());
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("/swordv2/statement/" + item.getID().toString())));
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("<title type=\"text\">" + itemTitle + "</title>")));
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)("<author><name>" + itemAuthor + "</name></author>")));
        MatcherAssert.assertThat((Object)((String)response.getBody()), (Matcher)CoreMatchers.containsString((String)"<category term=\"http://dspace.org/state/archived\""));
    }
}

