/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canManageTemplateItem", description="It can be used to verify if a collection template item can be created, deleted, viewed or edited")
public class ManageTemplateItemFeature
implements AuthorizationFeature {
    public static final String NAME = "canManageTemplateItem";
    @Autowired
    private Utils utils;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object instanceof CollectionRest) {
            try {
                AuthorizeUtil.authorizeManageTemplateItem((Context)context, (Collection)((Collection)this.utils.getDSpaceAPIObjectFromRest(context, object)));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.collection"};
    }
}

