/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.group.subgroups")
public class GroupGroupLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    GroupService groupService;

    @PreAuthorize(value="hasPermission(#groupId, 'GROUP', 'READ')")
    public Page<GroupRest> getGroups(@Nullable HttpServletRequest request, UUID groupId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Group group = (Group)this.groupService.find(context, groupId);
            if (group == null) {
                throw new ResourceNotFoundException("No such group: " + groupId);
            }
            int total = this.groupService.countByParent(context, group);
            Pageable pageable = this.utils.getPageable(optionalPageable);
            List memberGroups = this.groupService.findByParent(context, group, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(memberGroups, pageable, (long)total, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

