/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.IdentifierRest;
import org.dspace.app.rest.model.IdentifiersRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.service.DOIService;
import org.dspace.identifier.service.IdentifierService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.item.identifiers")
public class ItemIdentifierLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    ItemService itemService;
    @Autowired
    IdentifierService identifierService;
    @Autowired
    DOIService doiService;
    @Autowired
    HandleService handleService;

    @PreAuthorize(value="hasPermission(#itemId, 'ITEM', 'READ')")
    public IdentifiersRest getIdentifiers(@Nullable HttpServletRequest request, UUID itemId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException {
        Context context = ContextUtil.obtainCurrentRequestContext();
        Item item = (Item)this.itemService.find(context, itemId);
        if (item == null) {
            throw new ResourceNotFoundException("Could not find item with id " + itemId);
        }
        IdentifiersRest identifiersRest = new IdentifiersRest();
        ArrayList<IdentifierRest> identifierRestList = new ArrayList<IdentifierRest>();
        DOI doi = this.doiService.findDOIByDSpaceObject(context, (DSpaceObject)item);
        String handle = HandleServiceFactory.getInstance().getHandleService().findHandle(context, (DSpaceObject)item);
        try {
            if (doi != null) {
                String doiUrl = this.doiService.DOIToExternalForm(doi.getDoi());
                identifierRestList.add(new IdentifierRest(doiUrl, "doi", DOIIdentifierProvider.statusText[doi.getStatus()]));
            }
            if (handle != null) {
                identifierRestList.add(new IdentifierRest(this.handleService.getCanonicalForm(handle), "handle", null));
            }
        }
        catch (IdentifierException e) {
            throw new IllegalStateException("Failed to register identifier: " + e.getMessage());
        }
        identifiersRest.setIdentifiers(identifierRestList);
        return identifiersRest;
    }
}

