/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="workflow.workflowitem.submitter")
public class WorkflowItemSubmitterLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    XmlWorkflowItemService wis;

    @PreAuthorize(value="hasPermission(#id, 'WORKFLOWITEM', 'READ')")
    public EPersonRest getWorkflowItemSubmitter(@Nullable HttpServletRequest request, Integer id, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            WorkflowItem witem = this.wis.find(context, id.intValue());
            if (witem == null) {
                throw new ResourceNotFoundException("No such workflow item: " + id);
            }
            return (EPersonRest)this.converter.toRest((Object)witem.getSubmitter(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

