/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyPolicyTypeRemoveOperation<R>
extends PatchOperation<R> {
    public R perform(Context context, R resource, Operation operation) {
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.checkResourcePolicyForExistingPolicyTypeValue(resourcePolicy, operation);
            this.delete(resourcePolicy);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void delete(ResourcePolicy resourcePolicy) {
        resourcePolicy.setRpType(null);
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResourcePolicy && operation.getOp().trim().equalsIgnoreCase("remove") && operation.getPath().trim().equalsIgnoreCase("/policyType");
    }

    void checkResourcePolicyForExistingPolicyTypeValue(ResourcePolicy resource, Operation operation) {
        if (resource.getRpType() == null) {
            throw new DSpaceBadRequestException("Attempting to " + operation.getOp() + " a non-existent policyType value.");
        }
    }
}

