/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseCookie;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class DSpaceCsrfTokenRepository
implements CsrfTokenRepository {
    public static final String DEFAULT_CSRF_COOKIE_NAME = "DSPACE-XSRF-COOKIE";
    public static final String DSPACE_CSRF_HEADER_NAME = "DSPACE-XSRF-TOKEN";
    public static final String DEFAULT_CSRF_PARAMETER_NAME = "_csrf";
    public static final String DEFAULT_CSRF_HEADER_NAME = "X-XSRF-TOKEN";
    private String parameterName = "_csrf";
    private String headerName = "X-XSRF-TOKEN";
    private String cookieName = "DSPACE-XSRF-COOKIE";
    private boolean cookieHttpOnly = true;
    private String cookiePath;
    private String cookieDomain;

    public CsrfToken generateToken(HttpServletRequest request) {
        return new DefaultCsrfToken(this.headerName, this.parameterName, this.createNewToken());
    }

    public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
        String tokenValue = token == null ? "" : token.getToken();
        Cookie cookie = new Cookie(this.cookieName, tokenValue);
        cookie.setSecure(request.isSecure());
        if (this.cookiePath != null && !this.cookiePath.isEmpty()) {
            cookie.setPath(this.cookiePath);
        } else {
            cookie.setPath(this.getRequestContext(request));
        }
        if (token == null) {
            cookie.setMaxAge(0);
        } else {
            cookie.setMaxAge(-1);
        }
        cookie.setHttpOnly(this.cookieHttpOnly);
        if (this.cookieDomain != null && !this.cookieDomain.isEmpty()) {
            cookie.setDomain(this.cookieDomain);
        }
        String sameSite = "None";
        if (!cookie.getSecure()) {
            sameSite = "Lax";
        }
        ResponseCookie responseCookie = ResponseCookie.from((String)cookie.getName(), (String)cookie.getValue()).path(cookie.getPath()).maxAge((long)cookie.getMaxAge()).domain(cookie.getDomain()).httpOnly(cookie.isHttpOnly()).secure(cookie.getSecure()).sameSite(sameSite).build();
        response.addHeader("Set-Cookie", responseCookie.toString());
        if (StringUtils.hasLength((String)tokenValue)) {
            response.setHeader(DSPACE_CSRF_HEADER_NAME, tokenValue);
        }
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.cookieName);
        if (cookie == null) {
            return null;
        }
        String token = cookie.getValue();
        if (!StringUtils.hasLength((String)token)) {
            return null;
        }
        return new DefaultCsrfToken(this.headerName, this.parameterName, token);
    }

    public void setParameterName(String parameterName) {
        Assert.notNull((Object)parameterName, (String)"parameterName is not null");
        this.parameterName = parameterName;
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"headerName is not null");
        this.headerName = headerName;
    }

    public void setCookieName(String cookieName) {
        Assert.notNull((Object)cookieName, (String)"cookieName is not null");
        this.cookieName = cookieName;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    private String getRequestContext(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return contextPath.length() > 0 ? contextPath : "/";
    }

    public static DSpaceCsrfTokenRepository withHttpOnlyFalse() {
        DSpaceCsrfTokenRepository result = new DSpaceCsrfTokenRepository();
        result.setCookieHttpOnly(false);
        return result;
    }

    private String createNewToken() {
        return UUID.randomUUID().toString();
    }

    public void setCookiePath(String path) {
        this.cookiePath = path;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }
}

