/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.util.FrontendUrlService;

public class ItemContentBitstreamsProcessor
extends ItemSignpostingProcessor {
    private static final Logger log = LogManager.getLogger(ItemContentBitstreamsProcessor.class);

    public ItemContentBitstreamsProcessor(FrontendUrlService frontendUrlService) {
        super(frontendUrlService);
        this.setRelation(LinksetRelationType.ITEM);
    }

    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        try {
            for (Bundle bundle : item.getBundles("ORIGINAL")) {
                for (Bitstream bitstream : bundle.getBitstreams()) {
                    String mimeType = bitstream.getFormat(context).getMIMEType();
                    String bitstreamUrl = this.frontendUrlService.generateUrl(bitstream);
                    linksetNodes.add(new LinksetNode(bitstreamUrl, this.getRelation(), mimeType, this.buildAnchor(context, item)));
                }
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

