/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.MetadataValueAddPatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class ItemMetadataValueAddPatchOperation
extends MetadataValueAddPatchOperation<Item> {
    private static final Logger log = LogManager.getLogger(ItemMetadataValueAddPatchOperation.class);
    @Autowired
    ItemService itemService;
    @Autowired
    RelationshipService relationshipService;

    void add(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws SQLException {
        String[] split = this.getAbsolutePath(path).split("/");
        if (split.length == 1) {
            List list = this.evaluateArrayObject((LateObjectEvaluator)value);
            this.replaceValue(context, source.getItem(), split[0], list);
        } else {
            MetadataValueRest object = (MetadataValueRest)this.evaluateSingleObject((LateObjectEvaluator)value);
            List metadataByMetadataString = this.itemService.getMetadataByMetadataString((DSpaceObject)source.getItem(), split[0]);
            Assert.notEmpty((Collection)metadataByMetadataString);
            if (split.length > 1) {
                String controlChar;
                switch (controlChar = split[1]) {
                    case "-": {
                        this.addValue(context, (DSpaceObject)source.getItem(), split[0], object, -1);
                        break;
                    }
                    default: {
                        int index = Integer.parseInt(controlChar);
                        if (index > metadataByMetadataString.size()) {
                            throw new IllegalArgumentException("The specified index MUST NOT be greater than the number of elements in the array");
                        }
                        this.addValue(context, (DSpaceObject)source.getItem(), split[0], object, index);
                    }
                }
            }
        }
    }

    protected void replaceValue(Context context, Item source, String target, List<MetadataValueRest> list) throws SQLException {
        String[] metadata = Utils.tokenize((String)target);
        List preExistentMetadata = this.getDSpaceObjectService().getMetadata((DSpaceObject)source, metadata[0], metadata[1], metadata[2], "*");
        Map preExistentRelationships = this.preExistentRelationships(context, preExistentMetadata);
        this.getDSpaceObjectService().clearMetadata(context, (DSpaceObject)source, metadata[0], metadata[1], metadata[2], "*");
        for (Relationship rel : preExistentRelationships.values()) {
            try {
                Optional<MetadataValueRest> stillPresent = list.stream().filter(ll -> ll.getAuthority() != null && rel.getID().equals(this.getRelId(ll.getAuthority()))).findAny();
                if (!stillPresent.isEmpty()) continue;
                this.relationshipService.delete(context, (Object)rel);
            }
            catch (AuthorizeException e) {
                e.printStackTrace();
                throw new RuntimeException("Authorize Exception during relationship deletion.");
            }
        }
        int idx = 0;
        for (MetadataValueRest ll2 : list) {
            if (StringUtils.startsWith((CharSequence)ll2.getAuthority(), (CharSequence)"virtual::")) {
                Optional<MetadataValue> preExistentMv = preExistentMetadata.stream().filter(mvr -> StringUtils.equals((CharSequence)ll2.getAuthority(), (CharSequence)mvr.getAuthority())).findFirst();
                if (!preExistentMv.isPresent()) {
                    throw new UnprocessableEntityException("Relationship with authority=" + ll2.getAuthority() + " not found");
                }
                RelationshipMetadataValue rmv = (RelationshipMetadataValue)preExistentMv.get();
                Relationship rel = (Relationship)preExistentRelationships.get(rmv.getRelationshipId());
                this.updateRelationshipPlace(context, source, idx, rel);
            } else {
                this.getDSpaceObjectService().addMetadata(context, (DSpaceObject)source, metadata[0], metadata[1], metadata[2], ll2.getLanguage(), ll2.getValue(), ll2.getAuthority(), ll2.getConfidence(), idx);
            }
            ++idx;
        }
    }

    private Map<Integer, Relationship> preExistentRelationships(Context context, List<MetadataValue> preExistentMetadata) throws SQLException {
        HashMap<Integer, Relationship> relationshipsMap = new HashMap<Integer, Relationship>();
        for (MetadataValue ll : preExistentMetadata) {
            Relationship relationship;
            if (!(ll instanceof RelationshipMetadataValue) || (relationship = (Relationship)this.relationshipService.find(context, ((RelationshipMetadataValue)ll).getRelationshipId())) == null) continue;
            relationshipsMap.put(relationship.getID(), relationship);
        }
        return relationshipsMap;
    }

    private Integer getRelId(String authority) {
        int relId = Integer.parseInt(authority.split("virtual::")[1]);
        return relId;
    }

    private void updateRelationshipPlace(Context context, Item dso, int place, Relationship rs) {
        try {
            if (rs.getLeftItem().equals((Object)dso)) {
                rs.setLeftPlace(place);
            } else {
                rs.setRightPlace(place);
            }
            this.relationshipService.update(context, (Object)rs);
        }
        catch (Exception e) {
            log.error("An error occurred while moving " + rs.getID() + " for item " + dso.getID(), (Throwable)e);
        }
    }

    protected ItemService getDSpaceObjectService() {
        return this.itemService;
    }
}

