/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorizationFeatureServiceIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteService siteService;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private AuthorizationFeatureService authzFeatureService;

    @Test
    public void findAllTest() throws Exception {
        List authzFeatureServiceFindAll = this.authzFeatureService.findAll();
        Assert.assertThat((String)"We have at least our 7 mock features for testing", (Object)authzFeatureServiceFindAll.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(7)));
        HashSet<String> featureNames = new HashSet<String>();
        for (AuthorizationFeature f : authzFeatureServiceFindAll) {
            featureNames.add(f.getName());
        }
        Assert.assertThat((String)"all the features must have unique name", (Object)authzFeatureServiceFindAll.size(), (Matcher)Matchers.equalTo((Object)featureNames.size()));
    }

    @Test
    public void findTest() throws Exception {
        AuthorizationFeature aFeature = this.authzFeatureService.find("alwaystrue");
        Assert.assertThat((String)"check that one of our mock feature is retrieved", (Object)aFeature.getName(), (Matcher)Matchers.equalTo((Object)"alwaystrue"));
        AuthorizationFeature aNotExistingFeature = this.authzFeatureService.find("this feature doesn't exist!");
        Assert.assertThat((String)"check that not existing feature name return null", (Object)aNotExistingFeature, (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void findByResourceTypeTest() throws Exception {
        String siteUniqueType = "core.site";
        List siteFeatures = this.authzFeatureService.findByResourceType("core.site");
        Assert.assertThat((Object)siteFeatures.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        boolean alwaysTrueFound = false;
        for (AuthorizationFeature f : siteFeatures) {
            Assert.assertThat((Object)ArrayUtils.contains((Object[])f.getSupportedTypes(), (Object)"core.site"), (Matcher)Matchers.equalTo((Object)true));
            alwaysTrueFound = alwaysTrueFound || "alwaystrue".equals(f.getName());
        }
        Assert.assertThat((Object)alwaysTrueFound, (Matcher)Matchers.equalTo((Object)true));
        alwaysTrueFound = false;
        String collectionUniqueType = "core.collection";
        List collectionFeatures = this.authzFeatureService.findByResourceType("core.collection");
        for (AuthorizationFeature f : collectionFeatures) {
            Assert.assertThat((Object)ArrayUtils.contains((Object[])f.getSupportedTypes(), (Object)"core.collection"), (Matcher)Matchers.equalTo((Object)true));
            alwaysTrueFound = alwaysTrueFound || "alwaystrue".equals(f.getName());
        }
        List notExistingTypeFeatures = this.authzFeatureService.findByResourceType("NOT-EXISTING-TYPE");
        Assert.assertThat((Object)notExistingTypeFeatures.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void isAuthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        AuthorizationFeature alwaysTrue = this.authzFeatureService.find("alwaystrue");
        AuthorizationFeature alwaysFalse = this.authzFeatureService.find("alwaysfalse");
        AuthorizationFeature alwaysThrowEx = this.authzFeatureService.find("alwaysexception");
        AuthorizationFeature trueForAdmins = this.authzFeatureService.find("alwaystrueadmins");
        Assert.assertThat((Object)this.authzFeatureService.isAuthorized(this.context, alwaysTrue, (BaseObjectRest)siteRest), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.authzFeatureService.isAuthorized(this.context, alwaysFalse, (BaseObjectRest)siteRest), (Matcher)Matchers.equalTo((Object)false));
        try {
            this.authzFeatureService.isAuthorized(this.context, alwaysThrowEx, (BaseObjectRest)siteRest);
            Assert.assertThat((String)"the exception has been not re-thrown!", (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
        catch (Exception ex) {
            Assert.assertThat((String)"exceptions are rethrown", (Object)true, (Matcher)Matchers.equalTo((Object)true));
        }
        Assert.assertThat((Object)this.authzFeatureService.isAuthorized(this.context, trueForAdmins, (BaseObjectRest)siteRest), (Matcher)Matchers.equalTo((Object)false));
        this.context.setCurrentUser(this.admin);
        Assert.assertThat((Object)this.authzFeatureService.isAuthorized(this.context, trueForAdmins, (BaseObjectRest)siteRest), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.authzFeatureService.isAuthorized(this.context, alwaysTrue, null), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)this.authzFeatureService.isAuthorized(this.context, alwaysThrowEx, null), (Matcher)Matchers.equalTo((Object)false));
    }
}

