/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Arrays;
import org.dspace.app.rest.matcher.EntityTypeMatcher;
import org.dspace.app.rest.matcher.RelationshipTypeMatcher;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EntityTypeRestRepositoryIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private ExternalDataService externalDataService;
    @Autowired
    private EntityTypeService entityTypeService;

    @Test
    public void getAllEntityTypeEndpoint() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)8))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/core/entitytypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "none")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Publication")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Person")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "OrgUnit")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalVolume")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue"))})));
    }

    @Test
    public void getAllEntityTypeEndpointWithPaging() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0]).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)8))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/core/entitytypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalVolume")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "OrgUnit")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Person"))})));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0]).param("size", new String[]{"5"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)5))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)8))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/core/entitytypes"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Publication")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "none"))})));
    }

    @Test
    public void retrieveOneEntityType() throws Exception {
        EntityType entityType = this.entityTypeService.findByEntityType(this.context, "Publication");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/entitytypes/" + entityType.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", EntityTypeMatcher.matchEntityTypeEntry(entityType)));
    }

    @Test
    public void retrieveOneEntityTypeThatDoesNotExist() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/5555", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findAllPaginationTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalVolume"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)8))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes", (Object[])new Object[0]).param("page", new String[]{"1"}).param("size", new String[]{"3"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "OrgUnit")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Person")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"/api/core/entitytypes?"), (Matcher)Matchers.containsString((String)"page=2"), (Matcher)Matchers.containsString((String)"size=3")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)8))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findEntityTypeWithEmbedRelatioshipTypeTest() throws Exception {
        EntityType person = this.entityTypeService.findByEntityType(this.context, "Person");
        EntityType orgunit = this.entityTypeService.findByEntityType(this.context, "OrgUnit");
        EntityType project = this.entityTypeService.findByEntityType(this.context, "Project");
        EntityType publication = this.entityTypeService.findByEntityType(this.context, "Publication");
        EntityType journalIssue = this.entityTypeService.findByEntityType(this.context, "journalIssue");
        RelationshipType relationshipType1 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publication, person, "isAuthorOfPublication", "isPublicationOfAuthor");
        RelationshipType relationshipType2 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publication, project, "isProjectOfPublication", "isPublicationOfProject");
        RelationshipType relationshipType3 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publication, orgunit, "isOrgUnitOfPublication", "isPublicationOfOrgUnit");
        RelationshipType relationshipType4 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, journalIssue, publication, "isPublicationOfJournalIssue", "isJournalIssueOfPublication");
        RelationshipType relationshipType5 = this.relationshipTypeService.findbyTypesAndTypeName(this.context, publication, orgunit, "isAuthorOfPublication", "isPublicationOfAuthor");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/entitytypes/" + publication.getID()), (Object[])new Object[0]).param("embed", new String[]{"relationshiptypes"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", EntityTypeMatcher.matchEntityTypeEntry(publication))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.relationshiptypes._embedded.relationshiptypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType1), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType2), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType3), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType4), RelationshipTypeMatcher.matchRelationshipTypeEntry(relationshipType5)})));
    }

    @Test
    public void findAllByAuthorizedCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("JournalIssue").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 1").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 2").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 3").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Journal").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 4").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedCollection", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Publication")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal"))})));
    }

    @Test
    public void findAllByAuthorizedCollectionPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("JournalIssue").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 1").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 2").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 3").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Journal").withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 4").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedCollection", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "JournalIssue")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Journal"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedCollection", (Object[])new Object[0]).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Publication")), EntityTypeMatcher.matchEntityTypeEntry(this.entityTypeService.findByEntityType(this.context, "Project"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.first.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=0"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.last.href", (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"api/core/entitytypes/search/findAllByAuthorizedCollection?"), (Matcher)Matchers.containsString((String)"page=1"), (Matcher)Matchers.containsString((String)"size=2")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findAllByAuthorizedExternalSource() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publication = this.entityTypeService.findByEntityType(this.context, "Publication");
        EntityType orgUnit = this.entityTypeService.findByEntityType(this.context, "OrgUnit");
        EntityType project = this.entityTypeService.findByEntityType(this.context, "Project");
        EntityType funding = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Funding").build();
        Community rootCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withEntityType(orgUnit.getLabel()).withName("Collection 1").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withEntityType(publication.getLabel()).withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 2").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withEntityType(project.getLabel()).withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 3").build();
        CollectionBuilder.createCollection((Context)this.context, (Community)rootCommunity).withEntityType(funding.getLabel()).withSubmitterGroup(new EPerson[]{this.eperson}).withName("Collection 4").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedExternalSource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(publication), EntityTypeMatcher.matchEntityTypeEntry(funding), EntityTypeMatcher.matchEntityTypeEntry(project)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedExternalSource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(orgUnit), EntityTypeMatcher.matchEntityTypeEntry(funding), EntityTypeMatcher.matchEntityTypeEntry(project), EntityTypeMatcher.matchEntityTypeEntry(publication)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
        try {
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(Arrays.asList("Publication"));
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("pubmed")).setSupportedEntityTypes(Arrays.asList("Publication"));
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedExternalSource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(publication), EntityTypeMatcher.matchEntityTypeEntry(project)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/entitytypes/search/findAllByAuthorizedExternalSource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entitytypes", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{EntityTypeMatcher.matchEntityTypeEntry(project), EntityTypeMatcher.matchEntityTypeEntry(orgUnit), EntityTypeMatcher.matchEntityTypeEntry(publication)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        }
        finally {
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("mock")).setSupportedEntityTypes(null);
            ((AbstractExternalDataProvider)this.externalDataService.getExternalDataProvider("pubmed")).setSupportedEntityTypes(null);
        }
    }
}

