/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class IdentifierRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Before
    public void setup() throws Exception {
        super.setUp();
    }

    @Test
    public void testValidIdentifier() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.context.restoreAuthSystemState();
        String handle = this.parentCommunity.getHandle();
        String communityDetail = "http://localhost/api/core/communities/" + this.parentCommunity.getID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find?id={handle}", (Object[])new Object[]{handle})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", communityDetail));
    }

    @Test
    public void testValidIdentifierItemHandlePrefix() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection owningCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Owning Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)owningCollection).withTitle("Test item").build();
        String handle = item.getHandle();
        String itemLocation = "http://localhost/api/core/items/" + item.getID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find?id=hdl:{handle}", (Object[])new Object[]{handle})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", itemLocation));
    }

    @Test
    public void testUnexistentIdentifier() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find?id={id}", (Object[])new Object[]{"fakeIdentifier"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @Ignore
    public void testMissingIdentifierParameter() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/find", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testRegisterDoiForItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        DOIIdentifierProvider doiIdentifierProvider = (DOIIdentifierProvider)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("org.dspace.identifier.DOIIdentifierProvider", DOIIdentifierProvider.class);
        doiIdentifierProvider.delete(this.context, (DSpaceObject)publicItem1);
        String uriList = "https://localhost:8080/server/api/core/items/" + publicItem1.getID();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/pid/identifiers", (Object[])new Object[0]).queryParam("type", new String[]{"doi"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content(uriList)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/pid/identifiers", (Object[])new Object[0]).queryParam("type", new String[]{"doi"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content(uriList)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/pid/identifiers", (Object[])new Object[0]).queryParam("type", new String[]{"doi"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content(uriList)).andExpect(MockMvcResultMatchers.status().isBadRequest());
        DOI doi = doiService.findDOIByDSpaceObject(this.context, (DSpaceObject)publicItem1);
        Assert.assertNotNull((Object)doi);
        Assert.assertEquals((Object)DOIIdentifierProvider.TO_BE_REGISTERED, (Object)doi.getStatus());
        doi.setStatus(DOIIdentifierProvider.PENDING);
        doiService.update(this.context, doi);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/pid/identifiers", (Object[])new Object[0]).queryParam("type", new String[]{"doi"}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content(uriList)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetIdentifiersForItemByLink() throws Exception {
        this.context.turnOffAuthorisationSystem();
        DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
        HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        String doiString = "10.5072/dspace-identifier-test-" + publicItem1.getID();
        DOI doi = doiService.findDOIByDSpaceObject(this.context, (DSpaceObject)publicItem1);
        Assert.assertNotNull((Object)doi);
        doi.setDoi(doiString);
        doi.setStatus(DOIIdentifierProvider.IS_REGISTERED);
        doiService.update(this.context, doi);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID().toString() + "/identifiers"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Object[])new Object[0]).value((Object)"identifiers"));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID().toString() + "/identifiers"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers", (Object[])new Object[0]).isArray());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID().toString() + "/identifiers"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[0].type", (Object[])new Object[0]).value((Object)"identifier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[0].value", (Object[])new Object[0]).value((Object)doiService.DOIToExternalForm(doiString))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[0].identifierType", (Object[])new Object[0]).value((Object)"doi")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[0].identifierStatus", (Object[])new Object[0]).value((Object)DOIIdentifierProvider.statusText[DOIIdentifierProvider.IS_REGISTERED]));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + publicItem1.getID().toString() + "/identifiers"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[1].type", (Object[])new Object[0]).value((Object)"identifier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[1].value", (Object[])new Object[0]).value((Object)handleService.getCanonicalForm(publicItem1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.identifiers[1].identifierType", (Object[])new Object[0]).value((Object)"handle"));
    }

    @Test
    public void testFindIdentifiersByItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
        HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").build();
        String doiString = "10.5072/dspace-identifier-test-" + publicItem1.getID();
        DOI doi = doiService.findDOIByDSpaceObject(this.context, (DSpaceObject)publicItem1);
        Assert.assertNotNull((Object)doi);
        doi.setDoi(doiString);
        doi.setStatus(DOIIdentifierProvider.IS_REGISTERED);
        doiService.update(this.context, doi);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/identifiers/search/findByItem", (Object[])new Object[0]).queryParam("uuid", new String[]{publicItem1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers", (Object[])new Object[0]).exists());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/identifiers/search/findByItem", (Object[])new Object[0]).queryParam("uuid", new String[]{publicItem1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers", (Object[])new Object[0]).isArray());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/identifiers/search/findByItem", (Object[])new Object[0]).queryParam("uuid", new String[]{publicItem1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[0].type", (Object[])new Object[0]).value((Object)"identifier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[0].value", (Object[])new Object[0]).value((Object)doiService.DOIToExternalForm(doiString))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[0].identifierType", (Object[])new Object[0]).value((Object)"doi")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[0].identifierStatus", (Object[])new Object[0]).value((Object)DOIIdentifierProvider.statusText[DOIIdentifierProvider.IS_REGISTERED]));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/pid/identifiers/search/findByItem", (Object[])new Object[0]).queryParam("uuid", new String[]{publicItem1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[1].type", (Object[])new Object[0]).value((Object)"identifier")).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[1].value", (Object[])new Object[0]).value((Object)handleService.getCanonicalForm(publicItem1.getHandle()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.identifiers[1].identifierType", (Object[])new Object[0]).value((Object)"handle"));
    }
}

