/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.app.matcher.MetadataValueMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.ResourcePolicyMatcher;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.repository.patch.operation.ResearcherProfileAddOrcidOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.OrcidTokenBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.OrcidToken;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.exception.OrcidClientException;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.orcid.service.OrcidTokenService;
import org.dspace.profile.OrcidEntitySyncPreference;
import org.dspace.services.ConfigurationService;
import org.dspace.util.UUIDUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ResearcherProfileRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private OrcidTokenService orcidTokenService;
    @Autowired
    private OrcidQueueService orcidQueueService;
    @Autowired
    private ResearcherProfileAddOrcidOperation researcherProfileAddOrcidOperation;
    @Autowired
    private OrcidClient orcidClient;
    @Mock
    private OrcidClient orcidClientMock;
    @Autowired
    private OrcidSynchronizationService orcidSynchronizationService;
    private EPerson user;
    private EPerson anotherUser;
    private Collection personCollection;

    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.user = EPersonBuilder.createEPerson((Context)this.context).withEmail("user@example.com").withPassword(this.password).build();
        this.anotherUser = EPersonBuilder.createEPerson((Context)this.context).withEmail("anotherUser@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.personCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Profile Collection").withEntityType("Person").withSubmitterGroup(new EPerson[]{this.user}).withTemplateItem().build();
        this.configurationService.setProperty("researcher-profile.collection.uuid", (Object)this.personCollection.getID().toString());
        this.context.setCurrentUser(this.user);
        this.context.restoreAuthSystemState();
        this.useInstanceForBean(this.orcidSynchronizationService, this.orcidClientMock);
        this.useInstanceForBean(this.researcherProfileAddOrcidOperation, this.orcidClientMock);
    }

    @After
    public void after() {
        this.orcidTokenService.deleteAll(this.context);
        this.useInstanceForBean(this.orcidSynchronizationService, this.orcidClient);
        this.useInstanceForBean(this.researcherProfileAddOrcidOperation, this.orcidClient);
    }

    private <B, I> void useInstanceForBean(B bean, I instance) {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(instance.getClass())) continue;
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(bean, instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }

    @Test
    public void testFindById() throws Exception {
        UUID id = this.user.getID();
        String name = this.user.getFullName();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withDspaceObjectOwner(name, id.toString()).build();
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id.toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.object.owner", name, id.toString(), 0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.entity.type", "Person", 0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/eperson", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)));
    }

    @Test
    public void testFindByIdWithAdmin() throws Exception {
        UUID id = this.user.getID();
        String name = this.user.getFullName();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withDspaceObjectOwner(name, id.toString()).build();
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id.toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.object.owner", name, id.toString(), 0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.entity.type", "Person", 0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/eperson", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)));
    }

    @Test
    public void testFindByIdWithoutOwnerUser() throws Exception {
        UUID id = this.user.getID();
        String name = this.user.getFullName();
        String authToken = this.getAuthToken(this.anotherUser.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withDspaceObjectOwner(name, id.toString()).build();
        this.context.restoreAuthSystemState();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/eperson", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testCreateAndReturn() throws Exception {
        String id = this.user.getID().toString();
        String name = this.user.getName();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.object.owner", name, id, 0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.entity.type", "Person", 0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/eperson", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)));
        String itemId = this.getItemIdByProfileId(authToken, id);
        Item profileItem = (Item)this.itemService.find(this.context, UUIDUtils.fromString((String)itemId));
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/resourcepolicies/search/resource", (Object[])new Object[0]).param("uuid", new String[]{itemId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.resourcepolicies", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ResourcePolicyMatcher.matchResourcePolicyProperties(null, this.user, (DSpaceObject)profileItem, null, 0, null), ResourcePolicyMatcher.matchResourcePolicyProperties(null, this.user, (DSpaceObject)profileItem, null, 1, null)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void testCreateAndReturnWithPublicProfile() throws Exception {
        this.configurationService.setProperty("researcher-profile.set-new-profile-visible", (Object)true);
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
    }

    @Test
    public void testCreateAndReturnWithAdmin() throws Exception {
        String id = this.user.getID().toString();
        String name = this.user.getName();
        this.configurationService.setProperty("researcher-profile.collection.uuid", null);
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.object.owner", name, id, 0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.entity.type", "Person", 0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/eperson", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)));
        authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
    }

    @Test
    public void testCreateAndReturnWithoutCollectionIdSet() throws Exception {
        String id = this.user.getID().toString();
        this.configurationService.setProperty("researcher-profile.collection.uuid", null);
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
        String itemId = this.getItemIdByProfileId(authToken, id);
        Item profileItem = (Item)this.itemService.find(this.context, UUIDUtils.fromString((String)itemId));
        MatcherAssert.assertThat((Object)profileItem, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)profileItem.getOwningCollection(), (Matcher)Matchers.is((Object)this.personCollection));
    }

    @Test
    public void testCreateAndReturnWithCollectionHavingInvalidEntityTypeSet() throws Exception {
        String id = this.user.getID().toString();
        this.context.turnOffAuthorisationSystem();
        Collection orgUnitCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("OrgUnit Collection").withEntityType("OrgUnit").withSubmitterGroup(new EPerson[]{this.user}).withTemplateItem().build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("researcher-profile.collection.uuid", (Object)orgUnitCollection.getID().toString());
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + id, "item", "eperson")));
        String itemId = this.getItemIdByProfileId(authToken, id);
        Item profileItem = (Item)this.itemService.find(this.context, UUIDUtils.fromString((String)itemId));
        MatcherAssert.assertThat((Object)profileItem, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)profileItem.getOwningCollection(), (Matcher)Matchers.is((Object)this.personCollection));
    }

    @Test
    public void testCreateAndReturnWithoutOwnUser() throws Exception {
        String authToken = this.getAuthToken(this.anotherUser.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{this.user.getID().toString()}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testCreateAndReturnWithProfileAlreadyAssociated() throws Exception {
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testCreateAndReturnWithUnknownEPerson() throws Exception {
        String unknownId = UUID.randomUUID().toString();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{unknownId}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testDelete() throws Exception {
        this.configurationService.setProperty("researcher-profile.hard-delete.enabled", (Object)false);
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        AtomicReference itemIdRef = new AtomicReference();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", MetadataMatcher.matchMetadataNotEmpty("dspace.object.owner")))).andDo(result -> itemIdRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{id}", (Object[])new Object[]{itemIdRef.get()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", MetadataMatcher.matchMetadataDoesNotExist("dspace.object.owner"))));
    }

    @Test
    public void testHardDelete() throws Exception {
        this.configurationService.setProperty("researcher-profile.hard-delete.enabled", (Object)true);
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        AtomicReference itemIdRef = new AtomicReference();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", MetadataMatcher.matchMetadataNotEmpty("dspace.object.owner")))).andDo(result -> itemIdRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{id}", (Object[])new Object[]{itemIdRef.get()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testDeleteWithProfileLinkedWithOrcid() throws Exception {
        this.configurationService.setProperty("researcher-profile.hard-delete.enabled", (Object)false);
        this.context.turnOffAuthorisationSystem();
        Item profileItem = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withDspaceObjectOwner(this.user.getEmail(), this.user.getID().toString()).withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("access-token", this.eperson).withOrcidAuthenticated("authenticated").build();
        this.context.restoreAuthSystemState();
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        OrcidToken orcidToken = this.orcidTokenService.findByProfileItem(this.context, profileItem);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("person.identifier.orcid", "0000-1111-2222-3333")));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.authenticated", "authenticated")));
        MatcherAssert.assertThat((Object)orcidToken.getAccessToken(), (Matcher)Matchers.notNullValue());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", MetadataMatcher.matchMetadataNotEmpty("dspace.object.owner"))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).revokeToken(ResearcherProfileRestRepositoryIT.matchesToken(orcidToken));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profileItem = (Item)this.context.reloadEntity((ReloadableEntity)profileItem);
        orcidToken = this.orcidTokenService.findByProfileItem(this.context, profileItem);
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("person.identifier.orcid", "0000-1111-2222-3333"))));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.authenticated", "authenticated"))));
        MatcherAssert.assertThat((Object)orcidToken, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDeleteWithAdmin() throws Exception {
        String id = this.user.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testDeleteProfileCreatedByAnAdmin() throws Exception {
        String id = this.user.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testDeleteWithoutOwnUser() throws Exception {
        String id = this.user.getID().toString();
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        String anotherUserToken = this.getAuthToken(this.anotherUser.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(anotherUserToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testPatchToChangeVisibleAttribute() throws Exception {
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
        String itemId = this.getItemIdByProfileId(authToken, id);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{id}", (Object[])new Object[]{itemId})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/visible", (Object)true));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{id}", (Object[])new Object[]{itemId})).andExpect(MockMvcResultMatchers.status().isOk());
        operations = Arrays.asList(new ReplaceOperation("/visible", (Object)false));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/items/{id}", (Object[])new Object[]{itemId})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testPatchToChangeVisibleAttributeWithoutOwnUser() throws Exception {
        String id = this.user.getID().toString();
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        String anotherUserToken = this.getAuthToken(this.anotherUser.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/visible", (Object)true));
        this.getClient(anotherUserToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void testPatchToChangeVisibleAttributeWithAdmin() throws Exception {
        String id = this.user.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/visible", (Object)true));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true)));
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void testPatchToChangeVisibilityOfProfileCreatedByAnAdmin() throws Exception {
        String id = this.user.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/visible", (Object)true));
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true)));
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void testPatchToChangeVisibleAttributeOfNotExistProfile() throws Exception {
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/visible", (Object)true));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testAutomaticProfileClaimByEmail() throws Exception {
        String id = this.user.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        String firstItemId = this.getItemIdByProfileId(adminToken, id);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        String secondItemId = this.getItemIdByProfileId(adminToken, id);
        Assert.assertEquals((String)"The item should be the same", (Object)firstItemId, (Object)secondItemId);
    }

    @Test
    public void testAutomaticProfileClaimByEmailWithRegularEntity() throws Exception {
        String userToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        Item itemToBeClaimed = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail(this.user.getEmail()).build();
        this.context.restoreAuthSystemState();
        String id = this.user.getID().toString();
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNotFound());
        String newUserToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(newUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        String firstItemId = itemToBeClaimed.getID().toString();
        String secondItemId = this.getItemIdByProfileId(newUserToken, id);
        Assert.assertEquals((String)"The item should be the same", (Object)firstItemId, (Object)secondItemId);
    }

    @Test
    public void testNoAutomaticProfileClaimOccursIfManyClaimableItemsAreFound() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withNameInMetadata("Test", "User").withPassword(this.password).withEmail("test@email.it").build();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail("test@email.it").build();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail("test@email.it").build();
        this.context.restoreAuthSystemState();
        String epersonId = ePerson.getID().toString();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{epersonId})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testNoAutomaticProfileClaimOccursIfItemHasNotAnEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withNameInMetadata("Test", "User").withPassword(this.password).withEmail("test@email.it").build();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonIdentifierFirstName("Test").withPersonIdentifierLastName("User").build();
        this.context.restoreAuthSystemState();
        String epersonId = ePerson.getID().toString();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{epersonId})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testNoAutomaticProfileClaimOccursIfTheUserHasAlreadyAProfile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withNameInMetadata("Test", "User").withPassword(this.password).withEmail("test@email.it").build();
        this.context.restoreAuthSystemState();
        String epersonId = ePerson.getID().toString();
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{epersonId})).andExpect(MockMvcResultMatchers.status().isOk());
        String profileItemId = this.getItemIdByProfileId(token, epersonId);
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail("test@email.it").build();
        this.context.restoreAuthSystemState();
        token = this.getAuthToken(ePerson.getEmail(), this.password);
        String newProfileItemId = this.getItemIdByProfileId(token, epersonId);
        Assert.assertEquals((String)"The item should be the same", (Object)newProfileItemId, (Object)profileItemId);
    }

    @Test
    public void testNoAutomaticProfileClaimOccursIfTheFoundProfileIsAlreadyClaimed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withNameInMetadata("Test", "User").withPassword(this.password).withEmail("test@email.it").build();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Admin User").withPersonEmail("test@email.it").withDspaceObjectOwner("Admin User", this.admin.getID().toString()).build();
        this.context.restoreAuthSystemState();
        String epersonId = ePerson.getID().toString();
        String token = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{epersonId})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void researcherProfileClaim() throws Exception {
        String id = this.user.getID().toString();
        String name = this.user.getName();
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 1").withPersonEmail(this.user.getEmail()).build();
        Item otherPerson = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 2").withPersonEmail(this.user.getEmail()).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", HalMatcher.matchLinks("http://localhost/api/eperson/profiles/" + this.user.getID(), "item", "eperson")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"item"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.object.owner", name, id, 0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", MetadataMatcher.matchMetadata("dspace.entity.type", "Person", 0)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/eperson", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.is((Object)name)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + otherPerson.getID().toString())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("foo@bar.baz").withPassword(this.password).withNameInMetadata("Test", "User").build();
        this.context.restoreAuthSystemState();
        String ePersonToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void researcherProfileClaimWithoutEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 1").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void researcherProfileClaimWithDifferentEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 1").withPersonEmail(this.eperson.getEmail()).build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testNotAdminUserClaimProfileOfAnotherUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 1").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{this.anotherUser.getID().toString()}).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testAdminUserClaimProfileOfNotExistingPersonId() throws Exception {
        String id = "bef23ba3-9aeb-4f7b-b153-77b0f1fc3612";
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 1").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testAdminUserClaimProfileOfWrongPersonId() throws Exception {
        String id = "invalid_id";
        this.context.turnOffAuthorisationSystem();
        Item person = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("Test User 1").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).param("eperson", new String[]{id}).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + person.getID().toString())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void claimForNotAllowedEntityType() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection publications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)publications).withTitle("title").build();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + publication.getID().toString())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testOrcidMetadataOfEpersonAreCopiedOnProfile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)ePersonId.toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcid", (Matcher)Matchers.is((Object)"0000-1111-2222-3333"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.mode", (Matcher)Matchers.is((Object)"MANUAL"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.publicationsPreference", (Matcher)Matchers.is((Object)"DISABLED"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.fundingsPreference", (Matcher)Matchers.is((Object)"DISABLED"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.profilePreferences", (Matcher)Matchers.empty()));
        String itemId = this.getItemIdByProfileId(authToken, ePersonId);
        Item profileItem = (Item)this.itemService.find(this.context, UUIDUtils.fromString((String)itemId));
        MatcherAssert.assertThat((Object)profileItem, (Matcher)Matchers.notNullValue());
        List metadata = profileItem.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("person.identifier.orcid", "0000-1111-2222-3333")));
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", "/first-scope", 0)));
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", "/second-scope", 1)));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (Matcher)Matchers.is((Object)"af097328-ac1c-4a3e-9eb4-069897874910"));
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceForPublications() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/publications", (Object)OrcidEntitySyncPreference.ALL.name()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.publicationsPreference", (Matcher)Matchers.is((Object)OrcidEntitySyncPreference.ALL.name())));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.publicationsPreference", (Matcher)Matchers.is((Object)OrcidEntitySyncPreference.ALL.name())));
        operations = Arrays.asList(new ReplaceOperation("/orcid/publications", (Object)"INVALID_VALUE"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceForFundings() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/fundings", (Object)OrcidEntitySyncPreference.ALL.name()));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.fundingsPreference", (Matcher)Matchers.is((Object)OrcidEntitySyncPreference.ALL.name())));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.fundingsPreference", (Matcher)Matchers.is((Object)OrcidEntitySyncPreference.ALL.name())));
        operations = Arrays.asList(new ReplaceOperation("/orcid/fundings", (Object)"INVALID_VALUE"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceForProfile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/profile", (Object)"IDENTIFIERS"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.profilePreferences", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"IDENTIFIERS"})));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.profilePreferences", (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"IDENTIFIERS"})));
        operations = Arrays.asList(new ReplaceOperation("/orcid/profiles", (Object)"INVALID_VALUE"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationMode() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/mode", (Object)"BATCH"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.mode", (Matcher)Matchers.is((Object)"BATCH")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.mode", (Matcher)Matchers.is((Object)"BATCH")));
        operations = Arrays.asList(new ReplaceOperation("/orcid/mode", (Object)"MANUAL"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.mode", (Matcher)Matchers.is((Object)"MANUAL")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.mode", (Matcher)Matchers.is((Object)"MANUAL")));
        operations = Arrays.asList(new ReplaceOperation("/orcid/mode", (Object)"INVALID_VALUE"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceWithWrongPath() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/wrong-path", (Object)"BATCH"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceWithProfileNotLinkedToOrcid() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/mode", (Object)"BATCH"));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceWithNotOwnerUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/publications", (Object)OrcidEntitySyncPreference.ALL.name()));
        this.getClient(this.getAuthToken(this.user.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testPatchToSetOrcidSynchronizationPreferenceWithAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").withOrcidScope("/first-scope").withOrcidScope("/second-scope").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"af097328-ac1c-4a3e-9eb4-069897874910").build();
        this.context.restoreAuthSystemState();
        String ePersonId = ePerson.getID().toString();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated());
        List<Operation> operations = Arrays.asList(new ReplaceOperation("/orcid/publications", (Object)OrcidEntitySyncPreference.ALL.name()));
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId}).content(this.getPatchContent(operations)).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization.publicationsPreference", (Matcher)Matchers.is((Object)OrcidEntitySyncPreference.ALL.name())));
    }

    @Test
    public void testOwnerPatchToDisconnectProfileFromOrcidWithDisabledConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"disabled");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testAdminPatchToDisconnectProfileFromOrcidWithDisabledConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", null);
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testAnotherUserPatchToDisconnectProfileFromOrcidWithDisabledConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        EPerson anotherUser = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("user@email.it").withPassword(this.password).withNameInMetadata("Another", "User").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(anotherUser.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testOwnerPatchToDisconnectProfileFromOrcidWithOnlyOwnerConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"only_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidToken orcidToken = OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)ePerson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcid", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization", (Object[])new Object[0]).doesNotExist());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).revokeToken(ResearcherProfileRestRepositoryIT.matchesToken(orcidToken));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testPatchToDisconnectProfileFromOrcidDoesntRevokeOrcidToken() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"admin_and_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidToken orcidToken = OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        ((OrcidClient)Mockito.doThrow((Throwable[])new Throwable[]{new OrcidClientException(403, "")}).when((Object)this.orcidClientMock)).revokeToken((OrcidToken)ArgumentMatchers.any(OrcidToken.class));
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).revokeToken(ResearcherProfileRestRepositoryIT.matchesToken(orcidToken));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testAdminPatchToDisconnectProfileFromOrcidWithOnlyOwnerConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"only_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testAnotherUserPatchToDisconnectProfileFromOrcidWithOnlyOwnerConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"admin_and_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.anotherUser.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testOwnerPatchToDisconnectProfileFromOrcidWithOnlyAdminConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"only_admin");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testAdminPatchToDisconnectProfileFromOrcidWithOnlyAdminConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"only_admin");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidToken orcidToken = OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)ePerson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcid", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization", (Object[])new Object[0]).doesNotExist());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).revokeToken(ResearcherProfileRestRepositoryIT.matchesToken(orcidToken));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAnotherUserPatchToDisconnectProfileFromOrcidWithOnlyAdminConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"only_admin");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.anotherUser.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testOwnerPatchToDisconnectProfileFromOrcidWithAdminAndOwnerConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"admin_and_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidToken orcidToken = OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.getClient(this.getAuthToken(ePerson.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)ePerson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcid", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization", (Object[])new Object[0]).doesNotExist());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).revokeToken(ResearcherProfileRestRepositoryIT.matchesToken(orcidToken));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAdminPatchToDisconnectProfileFromOrcidWithAdminAndOwnerConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"admin_and_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidToken orcidToken = OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)ePerson.getID().toString()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcid", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.orcidSynchronization", (Object[])new Object[0]).doesNotExist());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).revokeToken(ResearcherProfileRestRepositoryIT.matchesToken(orcidToken));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAnotherUserPatchToDisconnectProfileFromOrcidWithAdminAndOwnerConfiguration() throws Exception {
        this.configurationService.setProperty("orcid.disconnection.allowed-users", (Object)"admin_and_owner");
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        Item profile = this.createProfile(ePerson);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
        this.context.restoreAuthSystemState();
        this.getClient(this.getAuthToken(this.anotherUser.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePerson.getID().toString()}).content(this.getPatchContent(Arrays.asList(new RemoveOperation("/orcid")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        profile = (Item)this.context.reloadEntity((ReloadableEntity)profile);
        MatcherAssert.assertThat(this.getMetadataValues(profile, "person.identifier.orcid"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.scope"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getMetadataValues(profile, "dspace.orcid.authenticated"), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profile), (Matcher)Matchers.is((Object)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4"));
    }

    @Test
    public void testCloneFromExternalProfileAlreadyAssociated() throws Exception {
        String id = this.user.getID().toString();
        String authToken = this.getAuthToken(this.user.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.visible", (Matcher)Matchers.is((Object)false))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"profile")));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType(RestMediaTypes.TEXT_URI_LIST).content("http://localhost:8080/server/api/core/items/" + id)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void testOrcidSynchronizationPreferenceUpdateForceOrcidQueueRecalculation() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType publicationType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType projectType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType personType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Person").build();
        EntityType orgUnitType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)personType, (EntityType)publicationType, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", (Integer)0, null, (Integer)0, null).build();
        RelationshipType isOrgUnitOfPerson = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)personType, (EntityType)orgUnitType, (String)"isOrgUnitOfPerson", (String)"isPersonOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipType isProjectOfPerson = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)projectType, (EntityType)personType, (String)"isProjectOfPerson", (String)"isPersonOfProject", (Integer)0, null, (Integer)0, null).build();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withOrcid("0000-1111-2222-3333").withOrcidScope("/read").withOrcidScope("/write").withEmail("test@email.it").withPassword(this.password).withNameInMetadata("Test", "User").build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)ePerson, (String)"3de2e370-8aa9-4bbe-8d7e-f5b1577bdad4").build();
        UUID ePersonId = ePerson.getID();
        Item profile = this.createProfile(ePerson);
        UUID profileItemId = profile.getID();
        Collection publications = this.createCollection("Publications", "Publication");
        Collection orgUnits = this.createCollection("OrgUnits", "OrgUnit");
        Item publication = this.createPublication(publications, "Test publication", profile, isAuthorOfPublication);
        Collection projects = this.createCollection("Projects", "Project");
        Item firstProject = this.createProject(projects, "First project", profile, isProjectOfPerson);
        Item secondProject = this.createProject(projects, "Second project", profile, isProjectOfPerson);
        this.createOrgUnit(orgUnits, "OrgUnit", profile, isOrgUnitOfPerson);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findByProfileItemId(this.context, profileItemId), (Matcher)Matchers.empty());
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId.toString()}).content(this.getPatchContent(Arrays.asList(new ReplaceOperation("/orcid/publications", (Object)"ALL")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        List queueRecords = this.orcidQueueService.findByProfileItemId(this.context, profileItemId);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)LambdaMatcher.has(this.orcidQueueRecordWithEntity(publication)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId.toString()}).content(this.getPatchContent(Arrays.asList(new ReplaceOperation("/orcid/fundings", (Object)"ALL")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        queueRecords = this.orcidQueueService.findByProfileItemId(this.context, profileItemId);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)LambdaMatcher.has(this.orcidQueueRecordWithEntity(publication)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)LambdaMatcher.has(this.orcidQueueRecordWithEntity(firstProject)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)LambdaMatcher.has(this.orcidQueueRecordWithEntity(secondProject)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId.toString()}).content(this.getPatchContent(Arrays.asList(new ReplaceOperation("/orcid/publications", (Object)"DISABLED")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        queueRecords = this.orcidQueueService.findByProfileItemId(this.context, profileItemId);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)LambdaMatcher.has(this.orcidQueueRecordWithEntity(firstProject)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)LambdaMatcher.has(this.orcidQueueRecordWithEntity(secondProject)));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{ePersonId.toString()}).content(this.getPatchContent(Arrays.asList(new ReplaceOperation("/orcid/fundings", (Object)"DISABLED")))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        MatcherAssert.assertThat((Object)this.orcidQueueService.findByProfileItemId(this.context, profileItemId), (Matcher)Matchers.empty());
    }

    @Test
    public void testLinkProfileWithValidCode() throws Exception {
        String code = "123456";
        String orcid = "0000-0000-1111-2222";
        String accessToken = "c41e37e5-c2de-4177-91d6-ed9e9d1f31bf";
        String[] scopes = new String[]{"FirstScope", "SecondScope"};
        this.context.turnOffAuthorisationSystem();
        Item profileItem = this.createProfile(this.user);
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(code)).thenReturn((Object)this.buildOrcidTokenResponse(orcid, accessToken, scopes));
        this.getClient(this.getAuthToken(this.user.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{this.user.getID().toString()}).content(this.getPatchContent(Arrays.asList(new AddOperation("/orcid", (Object)code)))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(code);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profileItem = (Item)this.context.reloadEntity((ReloadableEntity)profileItem);
        MatcherAssert.assertThat((Object)profileItem, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("person.identifier.orcid", orcid)));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", scopes[0], 0)));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", scopes[1], 1)));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (Matcher)Matchers.is((Object)accessToken));
        this.user = (EPerson)this.context.reloadEntity((ReloadableEntity)this.user);
        MatcherAssert.assertThat((Object)this.user.getNetid(), (Matcher)Matchers.is((Object)orcid));
    }

    @Test
    public void testLinkProfileWithAdmin() throws Exception {
        String code = "123456";
        String orcid = "0000-0000-1111-2222";
        String accessToken = "c41e37e5-c2de-4177-91d6-ed9e9d1f31bf";
        String[] scopes = new String[]{"FirstScope", "SecondScope"};
        this.context.turnOffAuthorisationSystem();
        Item profileItem = this.createProfile(this.user);
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(code)).thenReturn((Object)this.buildOrcidTokenResponse(orcid, accessToken, scopes));
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{this.user.getID().toString()}).content(this.getPatchContent(Arrays.asList(new AddOperation("/orcid", (Object)code)))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(code);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profileItem = (Item)this.context.reloadEntity((ReloadableEntity)profileItem);
        MatcherAssert.assertThat((Object)profileItem, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("person.identifier.orcid", orcid)));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", scopes[0], 0)));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", scopes[1], 1)));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (Matcher)Matchers.is((Object)accessToken));
        this.user = (EPerson)this.context.reloadEntity((ReloadableEntity)this.user);
        MatcherAssert.assertThat((Object)this.user.getNetid(), (Matcher)Matchers.is((Object)orcid));
    }

    @Test
    public void testLinkProfileWithInvalidCode() throws Exception {
        String code = "123456";
        this.context.turnOffAuthorisationSystem();
        Item profileItem = this.createProfile(this.user);
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(code)).thenThrow(new Throwable[]{new OrcidClientException(400, "{\n    \"error\": \"invalid_grant\",\n    \"error_description\": \"Invalid authorization code: 123456\"\n}")});
        this.getClient(this.getAuthToken(this.user.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{this.user.getID().toString()}).content(this.getPatchContent(Arrays.asList(new AddOperation("/orcid", (Object)code)))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(code);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testLinkProfileWithGenericError() throws Exception {
        String code = "123456";
        this.context.turnOffAuthorisationSystem();
        Item profileItem = this.createProfile(this.user);
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(code)).thenThrow(new Throwable[]{new OrcidClientException(401, "Forbidden")});
        this.getClient(this.getAuthToken(this.user.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{this.user.getID().toString()}).content(this.getPatchContent(Arrays.asList(new AddOperation("/orcid", (Object)code)))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getAccessToken(code);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testLinkProfileForbiddenForNotOwnerUser() throws Exception {
        String code = "123456";
        String orcid = "0000-0000-1111-2222";
        String accessToken = "c41e37e5-c2de-4177-91d6-ed9e9d1f31bf";
        String[] scopes = new String[]{"FirstScope", "SecondScope"};
        this.context.turnOffAuthorisationSystem();
        Item profileItem = this.createProfile(this.user);
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.getAccessToken(code)).thenReturn((Object)this.buildOrcidTokenResponse(orcid, accessToken, scopes));
        this.getClient(this.getAuthToken(this.anotherUser.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{this.user.getID().toString()}).content(this.getPatchContent(Arrays.asList(new AddOperation("/orcid", (Object)code)))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        profileItem = (Item)this.context.reloadEntity((ReloadableEntity)profileItem);
        MatcherAssert.assertThat((Object)profileItem, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("person.identifier.orcid", orcid))));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", scopes[0], 0))));
        MatcherAssert.assertThat((Object)profileItem.getMetadata(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataValueMatcher.with("dspace.orcid.scope", scopes[1], 1))));
        MatcherAssert.assertThat((Object)this.getOrcidAccessToken(profileItem), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testLinkProfileWithEPersonWithoutProfile() throws Exception {
        String code = "123456";
        String orcid = "0000-0000-1111-2222";
        String accessToken = "c41e37e5-c2de-4177-91d6-ed9e9d1f31bf";
        String[] scopes = new String[]{"FirstScope", "SecondScope"};
        Mockito.when((Object)this.orcidClientMock.getAccessToken(code)).thenReturn((Object)this.buildOrcidTokenResponse(orcid, accessToken, scopes));
        this.getClient(this.getAuthToken(this.user.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)"/api/eperson/profiles/{id}", (Object[])new Object[]{this.user.getID().toString()}).content(this.getPatchContent(Arrays.asList(new AddOperation("/orcid", (Object)code)))).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isNotFound());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    private Item createProfile(EPerson ePerson) throws Exception {
        String authToken = this.getAuthToken(ePerson.getEmail(), this.password);
        AtomicReference ePersonIdRef = new AtomicReference();
        AtomicReference itemIdRef = new AtomicReference();
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/profiles/", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> ePersonIdRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{ePersonIdRef.get()}).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> itemIdRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        return (Item)this.itemService.find(this.context, (UUID)itemIdRef.get());
    }

    private String getItemIdByProfileId(String token, String id) throws SQLException, Exception {
        MvcResult result = this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/profiles/{id}/item", (Object[])new Object[]{id})).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        return (String)this.readAttributeFromResponse(result, "$.id");
    }

    private String getOrcidAccessToken(Item item) {
        OrcidToken orcidToken = this.orcidTokenService.findByProfileItem(this.context, item);
        return orcidToken != null ? orcidToken.getAccessToken() : null;
    }

    private List<MetadataValue> getMetadataValues(Item item, String metadataField) {
        return this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadataField);
    }

    private Collection createCollection(String name, String entityType) throws SQLException {
        return CollectionBuilder.createCollection((Context)this.context, (Community)((Community)this.context.reloadEntity((ReloadableEntity)this.parentCommunity))).withName(name).withEntityType(entityType).build();
    }

    private Item createPublication(Collection collection, String title, Item author, RelationshipType isAuthorOfPublication) {
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle(title).withAuthor(author.getName()).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)author, (Item)publication, (RelationshipType)isAuthorOfPublication).build();
        return publication;
    }

    private Item createOrgUnit(Collection collection, String title, Item person, RelationshipType isOrgUnitOfPerson) {
        Item orgUnit = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle(title).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)person, (Item)orgUnit, (RelationshipType)isOrgUnitOfPerson).build();
        return orgUnit;
    }

    private Item createProject(Collection collection, String title, Item person, RelationshipType isProjectOfPerson) {
        Item project = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle(title).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)project, (Item)person, (RelationshipType)isProjectOfPerson).build();
        return project;
    }

    private java.util.function.Predicate<OrcidQueue> orcidQueueRecordWithEntity(Item entity) {
        return orcidQueue -> entity.equals((Object)orcidQueue.getEntity());
    }

    private <T> T readAttributeFromResponse(MvcResult result, String attribute) throws UnsupportedEncodingException {
        return (T)JsonPath.read((String)result.getResponse().getContentAsString(), (String)attribute, (Predicate[])new Predicate[0]);
    }

    private OrcidTokenResponseDTO buildOrcidTokenResponse(String orcid, String accessToken, String[] scopes) {
        OrcidTokenResponseDTO token = new OrcidTokenResponseDTO();
        token.setAccessToken(accessToken);
        token.setOrcid(orcid);
        token.setTokenType("Bearer");
        token.setName("Test User");
        token.setScope(String.join((CharSequence)" ", scopes));
        return token;
    }

    private static OrcidToken matchesToken(OrcidToken orcidToken) {
        return (OrcidToken)ArgumentMatchers.argThat(token -> token != null && orcidToken.getAccessToken().equals(token.getAccessToken()) && orcidToken.getID().equals(token.getID()));
    }
}

