/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.util.UUID;
import org.dspace.app.rest.matcher.VocabularyEntryDetailsMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class VocabularyEntryDetailsIT
extends AbstractControllerIntegrationTest {
    @Test
    public void discoverableNestedLinkTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.vocabularyEntryDetails.href", (Matcher)Matchers.is((Object)"http://localhost/api/submission/vocabularyEntryDetails")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.vocabularyEntryDetails-search.href", (Matcher)Matchers.is((Object)"http://localhost/api/submission/vocabularyEntryDetails/search")))));
    }

    @Test
    public void findAllTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneTest() throws Exception {
        String idAuthority = "srsc:SCB110";
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/vocabularyEntryDetails/" + idAuthority), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB110", "Religion/Theology", "HUMANITIES and RELIGION::Religion/Theology"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.selectable", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.otherInformation.id", (Matcher)Matchers.is((Object)"SCB110"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.otherInformation.note", (Matcher)Matchers.is((Object)"Religionsvetenskap/Teologi"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.otherInformation.parent", (Matcher)Matchers.is((Object)"HUMANITIES and RELIGION"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.parent.href", (Matcher)Matchers.endsWith((String)"api/submission/vocabularyEntryDetails/srsc:SCB110/parent"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.children.href", (Matcher)Matchers.endsWith((String)"api/submission/vocabularyEntryDetails/srsc:SCB110/children")));
    }

    @Test
    public void findOneAnonymousTest() throws Exception {
        String idAuthority = "srsc:SCB110";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/vocabularyEntryDetails/" + idAuthority), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String idAuthority = "srsc:not-existing";
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/vocabularyEntryDetails/" + idAuthority), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:ResearchSubjectCategories", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void srscSearchTopTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.vocabularyEntryDetails", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB11", "HUMANITIES and RELIGION", "HUMANITIES and RELIGION"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB12", "LAW/JURISPRUDENCE", "LAW/JURISPRUDENCE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB13", "SOCIAL SCIENCES", "SOCIAL SCIENCES"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB14", "MATHEMATICS", "MATHEMATICS"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB15", "NATURAL SCIENCES", "NATURAL SCIENCES"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB16", "TECHNOLOGY", "TECHNOLOGY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB17", "FORESTRY, AGRICULTURAL SCIENCES and LANDSCAPE PLANNING", "FORESTRY, AGRICULTURAL SCIENCES and LANDSCAPE PLANNING"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB18", "MEDICINE", "MEDICINE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB19", "ODONTOLOGY", "ODONTOLOGY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB21", "PHARMACY", "PHARMACY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB22", "VETERINARY MEDICINE", "VETERINARY MEDICINE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB23", "INTERDISCIPLINARY RESEARCH AREAS", "INTERDISCIPLINARY RESEARCH AREAS")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12)));
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.vocabularyEntryDetails", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB11", "HUMANITIES and RELIGION", "HUMANITIES and RELIGION"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB12", "LAW/JURISPRUDENCE", "LAW/JURISPRUDENCE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB13", "SOCIAL SCIENCES", "SOCIAL SCIENCES"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB14", "MATHEMATICS", "MATHEMATICS"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB15", "NATURAL SCIENCES", "NATURAL SCIENCES"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB16", "TECHNOLOGY", "TECHNOLOGY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB17", "FORESTRY, AGRICULTURAL SCIENCES and LANDSCAPE PLANNING", "FORESTRY, AGRICULTURAL SCIENCES and LANDSCAPE PLANNING"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB18", "MEDICINE", "MEDICINE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB19", "ODONTOLOGY", "ODONTOLOGY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB21", "PHARMACY", "PHARMACY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB22", "VETERINARY MEDICINE", "VETERINARY MEDICINE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB23", "INTERDISCIPLINARY RESEARCH AREAS", "INTERDISCIPLINARY RESEARCH AREAS")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12)));
    }

    @Test
    public void srscSearchFirstLevel_MATHEMATICS_Test() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB14/children", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB1401", "Algebra, geometry and mathematical analysis", "MATHEMATICS::Algebra, geometry and mathematical analysis"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB1402", "Applied mathematics", "MATHEMATICS::Applied mathematics"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB1409", "Other mathematics", "MATHEMATICS::Other mathematics")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children[*].otherInformation.parent", (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)"MATHEMATICS")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void srscSearchTopPaginationTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"}).param("page", new String[]{"0"}).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.vocabularyEntryDetails", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB11", "HUMANITIES and RELIGION", "HUMANITIES and RELIGION"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB12", "LAW/JURISPRUDENCE", "LAW/JURISPRUDENCE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB13", "SOCIAL SCIENCES", "SOCIAL SCIENCES"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB14", "MATHEMATICS", "MATHEMATICS"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB15", "NATURAL SCIENCES", "NATURAL SCIENCES")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"}).param("page", new String[]{"1"}).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.vocabularyEntryDetails", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB16", "TECHNOLOGY", "TECHNOLOGY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB17", "FORESTRY, AGRICULTURAL SCIENCES and LANDSCAPE PLANNING", "FORESTRY, AGRICULTURAL SCIENCES and LANDSCAPE PLANNING"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB18", "MEDICINE", "MEDICINE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB19", "ODONTOLOGY", "ODONTOLOGY"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB21", "PHARMACY", "PHARMACY")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"}).param("page", new String[]{"2"}).param("size", new String[]{"5"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.vocabularyEntryDetails", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB22", "VETERINARY MEDICINE", "VETERINARY MEDICINE"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB23", "INTERDISCIPLINARY RESEARCH AREAS", "INTERDISCIPLINARY RESEARCH AREAS")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void searchTopBadRequestTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void searchTopAnonymousTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void srscSearchByParentFirstLevelPaginationTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB14/children", (Object[])new Object[0]).param("page", new String[]{"0"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB1401", "Algebra, geometry and mathematical analysis", "MATHEMATICS::Algebra, geometry and mathematical analysis"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB1402", "Applied mathematics", "MATHEMATICS::Applied mathematics")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB14/children", (Object[])new Object[0]).param("page", new String[]{"1"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children", (Matcher)Matchers.contains(VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB1409", "Other mathematics", "MATHEMATICS::Other mathematics")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void srscSearchByParentSecondLevel_Applied_mathematics_Test() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB1402/children", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR140202", "Numerical analysis", "MATHEMATICS::Applied mathematics::Numerical analysis"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR140203", "Mathematical statistics", "MATHEMATICS::Applied mathematics::Mathematical statistics"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR140204", "Optimization, systems theory", "MATHEMATICS::Applied mathematics::Optimization, systems theory"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR140205", "Theoretical computer science", "MATHEMATICS::Applied mathematics::Theoretical computer science")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4)));
    }

    @Test
    public void srscSearchByParentEmptyTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:VR140202/children", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void srscSearchByParentWrongIdTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/vocabularyEntryDetails/" + UUID.randomUUID() + "/children"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void srscSearchTopAnonymousTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search/top", (Object[])new Object[0]).param("vocabulary", new String[]{"srsc"})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findParentByChildTest() throws Exception {
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB180/parent", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB18", "MEDICINE", "MEDICINE"))));
    }

    @Test
    public void findParentByChildBadRequestTest() throws Exception {
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/vocabularyEntryDetails/" + UUID.randomUUID() + "/parent"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findParentByChildAnonymousTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB180/parent", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findParentTopTest() throws Exception {
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB11/parent", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void srscProjectionTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB110", (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parent", VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB11", "HUMANITIES and RELIGION", "HUMANITIES and RELIGION"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children._embedded.children", this.matchAllSrscSC110Children())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children._embedded.children[*].otherInformation.parent", (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)"HUMANITIES and RELIGION::Religion/Theology"))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB110", (Object[])new Object[0]).param("embed", new String[]{"children"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children._embedded.children", this.matchAllSrscSC110Children())).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.children._embedded.children[*].otherInformation.parent", (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)"HUMANITIES and RELIGION::Religion/Theology"))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/srsc:SCB110", (Object[])new Object[0]).param("embed", new String[]{"parent"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.parent", VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:SCB11", "HUMANITIES and RELIGION", "HUMANITIES and RELIGION")));
    }

    private Matcher<Iterable<? extends Object>> matchAllSrscSC110Children() {
        return Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110102", "History of religion", "HUMANITIES and RELIGION::Religion/Theology::History of religion"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110103", "Church studies", "HUMANITIES and RELIGION::Religion/Theology::Church studies"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110104", "Missionary studies", "HUMANITIES and RELIGION::Religion/Theology::Missionary studies"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110105", "Systematic theology", "HUMANITIES and RELIGION::Religion/Theology::Systematic theology"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110106", "Islamology", "HUMANITIES and RELIGION::Religion/Theology::Islamology"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110107", "Faith and reason", "HUMANITIES and RELIGION::Religion/Theology::Faith and reason"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110108", "Sociology of religion", "HUMANITIES and RELIGION::Religion/Theology::Sociology of religion"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110109", "Psychology of religion", "HUMANITIES and RELIGION::Religion/Theology::Psychology of religion"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110110", "Philosophy of religion", "HUMANITIES and RELIGION::Religion/Theology::Philosophy of religion"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110111", "New Testament exegesis", "HUMANITIES and RELIGION::Religion/Theology::New Testament exegesis"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110112", "Old Testament exegesis", "HUMANITIES and RELIGION::Religion/Theology::Old Testament exegesis"), VocabularyEntryDetailsMatcher.matchAuthorityEntry("srsc:VR110113", "Dogmatics with symbolics", "HUMANITIES and RELIGION::Religion/Theology::Dogmatics with symbolics")});
    }

    @Test
    public void vocabularyEntryDetailSerchMethodWithSingleModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetail/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void vocabularyEntryDetailSerchMethodWithPluralModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularyEntryDetails/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.top.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"/api/submission/vocabularyEntryDetails/search/top")})));
    }
}

