/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.dspace.app.rest.matcher.VocabularyMatcher;
import org.dspace.app.rest.repository.SubmissionFormRestRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.PersonAuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.orcid.MockOrcid;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.authority.DCInputAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class VocabularyRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    private SubmissionFormRestRepository submissionFormRestRepository;
    @Autowired
    private PluginService pluginService;
    @Autowired
    private ChoiceAuthorityService cas;

    @Before
    public void setup() throws Exception {
        super.setUp();
        ConfigurableApplicationContext applicationContext = DSpaceServicesFactory.getInstance().getServiceManager().getApplicationContext();
        MockOrcid mockOrcid = (MockOrcid)applicationContext.getBean(MockOrcid.class);
        mockOrcid.setupNoResultsSearch();
        mockOrcid.setupSingleSearch();
        mockOrcid.setupSearchWithResults();
        this.configurationService.setProperty("plugin.named.org.dspace.content.authority.ChoiceAuthority", (Object)new String[]{"org.dspace.content.authority.SolrAuthority = SolrAuthorAuthority", "org.dspace.content.authority.SHERPARoMEOPublisher = SRPublisher", "org.dspace.content.authority.SHERPARoMEOJournalTitle = SRJournalTitle"});
        this.configurationService.setProperty("solr.authority.server", (Object)"${solr.server}/authority");
        this.configurationService.setProperty("choices.plugin.dc.contributor.author", (Object)"SolrAuthorAuthority");
        this.configurationService.setProperty("choices.presentation.dc.contributor.author", (Object)"authorLookup");
        this.configurationService.setProperty("authority.controlled.dc.contributor.author", (Object)"true");
        this.configurationService.setProperty("authority.author.indexer.field.1", (Object)"dc.contributor.author");
        this.configurationService.setProperty("choices.plugin.dc.publisher", (Object)"SRPublisher");
        this.configurationService.setProperty("choices.presentation.dc.publisher", (Object)"lookup");
        this.configurationService.setProperty("authority.controlled.dc.publisher", (Object)"true");
        this.configurationService.setProperty("choices.plugin.dc.relation.ispartof", (Object)"SRJournalTitle");
        this.configurationService.setProperty("choices.presentation.dc.relation.ispartof", (Object)"lookup");
        this.configurationService.setProperty("authority.controlled.dc.relation.ispartof", (Object)"true");
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.getChoiceAuthoritiesNames();
        this.cas.clearCache();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("A parent community for all our test").build();
        this.context.restoreAuthSystemState();
        PersonAuthorityValue person1 = new PersonAuthorityValue();
        person1.setId(String.valueOf(UUID.randomUUID()));
        person1.setLastName("Shirasaka");
        person1.setFirstName("Seiko");
        person1.setValue("Shirasaka, Seiko");
        person1.setField("dc_contributor_author");
        person1.setLastModified(new Date());
        person1.setCreationDate(new Date());
        AuthorityServiceFactory.getInstance().getAuthorityIndexingService().indexContent((AuthorityValue)person1);
        PersonAuthorityValue person2 = new PersonAuthorityValue();
        person2.setId(String.valueOf(UUID.randomUUID()));
        person2.setLastName("Miller");
        person2.setFirstName("Tyler E");
        person2.setValue("Miller, Tyler E");
        person2.setField("dc_contributor_author");
        person2.setLastModified(new Date());
        person2.setCreationDate(new Date());
        AuthorityServiceFactory.getInstance().getAuthorityIndexingService().indexContent((AuthorityValue)person2);
        AuthorityServiceFactory.getInstance().getAuthorityIndexingService().commit();
    }

    @After
    public void destroy() throws Exception {
        super.destroy();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
    }

    @Test
    public void findAllTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.vocabularies", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchProperties("srsc", "srsc", false, true), VocabularyMatcher.matchProperties("common_types", "common_types", true, false), VocabularyMatcher.matchProperties("common_iso_languages", "common_iso_languages", true, false), VocabularyMatcher.matchProperties("SolrAuthorAuthority", "SolrAuthorAuthority", false, false), VocabularyMatcher.matchProperties("SRPublisher", "SRPublisher", false, false), VocabularyMatcher.matchProperties("SRJournalTitle", "SRJournalTitle", false, false)}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"api/submission/vocabularies"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)6)));
    }

    @Test
    public void findOneSRSC_Test() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/srsc", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VocabularyMatcher.matchProperties("srsc", "srsc", false, true))));
    }

    @Test
    public void findOneCommonTypesTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_types", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VocabularyMatcher.matchProperties("common_types", "common_types", true, false))));
    }

    @Test
    public void correctSrscQueryTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/srsc/entries", (Object[])new Object[0]).param("filter", new String[]{"Research"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Research Subject Categories", "", "vocabularyEntry"), VocabularyMatcher.matchVocabularyEntry("Family research", "SOCIAL SCIENCES::Social sciences::Social work::Family research", "vocabularyEntry")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)26))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)13))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void notScrollableVocabularyRequiredQueryTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/srsc/entries", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void noResultsSrscQueryTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/srsc/entries", (Object[])new Object[0]).param("metadata", new String[]{"dc.subject"}).param("filter", new String[]{"Research2"}).param("size", new String[]{"1000"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void vocabularyEntriesCommonTypesWithPaginationTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_types/entries", (Object[])new Object[0]).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Animation", "Animation", "vocabularyEntry"), VocabularyMatcher.matchVocabularyEntry("Article", "Article", "vocabularyEntry")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[*].authority", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)22))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)11))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_types/entries", (Object[])new Object[0]).param("size", new String[]{"2"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Book", "Book", "vocabularyEntry"), VocabularyMatcher.matchVocabularyEntry("Book chapter", "Book chapter", "vocabularyEntry")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[*].authority", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)22))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)11))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void vocabularyEntriesCommon_typesWithQueryTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_types/entries", (Object[])new Object[0]).param("filter", new String[]{"Book"}).param("size", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("Book", "Book", "vocabularyEntry"), VocabularyMatcher.matchVocabularyEntry("Book chapter", "Book chapter", "vocabularyEntry")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void vocabularyEntriesDCInputAuthorityLocalesTest() throws Exception {
        String[] supportedLanguage = new String[]{"it", "uk"};
        this.configurationService.setProperty("default.locale", (Object)"it");
        this.configurationService.setProperty("webui.supported.locales", (Object)supportedLanguage);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
        Locale uk = new Locale("uk");
        Locale it = new Locale("it");
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_iso_languages/entries", (Object[])new Object[0]).param("size", new String[]{"2"}).locale(it)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("N/A", "", "vocabularyEntry"), VocabularyMatcher.matchVocabularyEntry("Inglese (USA)", "en_US", "vocabularyEntry")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[*].authority", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_iso_languages/entries", (Object[])new Object[0]).param("size", new String[]{"2"}).locale(uk)).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VocabularyMatcher.matchVocabularyEntry("N/A", "", "vocabularyEntry"), VocabularyMatcher.matchVocabularyEntry("\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u044c\u043a\u0430 (USA)", "en_US", "vocabularyEntry")}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[*].authority", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)12))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)2)));
        this.configurationService.setProperty("default.locale", (Object)"en");
        this.configurationService.setProperty("webui.supported.locales", null);
        this.submissionFormRestRepository.reload();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.cas.clearCache();
    }

    @Test
    public void correctSolrQueryTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/SolrAuthorAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Shirasaka"}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(VocabularyMatcher.matchVocabularyEntry("Shirasaka, Seiko", "Shirasaka, Seiko", "vocabularyEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[0].authority", (Object[])new Object[0]).isNotEmpty()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/SolrAuthorAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Bollini"}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(VocabularyMatcher.matchVocabularyEntry("Bollini, Andrea", "Bollini, Andrea", "vocabularyEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[0].authority", (Matcher)Matchers.is((Object)"will be generated::orcid::0000-0002-9029-1854"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void noResultsSolrQueryTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/SolrAuthorAuthority/entries", (Object[])new Object[0]).param("filter", new String[]{"Smith"}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void sherpaJournalTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/SRJournalTitle/entries", (Object[])new Object[0]).param("filter", new String[]{"Lancet"}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(VocabularyMatcher.matchVocabularyEntry("The Lancet", "The Lancet", "vocabularyEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[0].authority", (Matcher)Matchers.is((Object)"0140-6736"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void sherpaPublisherTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/SRPublisher/entries", (Object[])new Object[0]).param("filter", new String[]{"PLOS"}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(VocabularyMatcher.matchVocabularyEntry("Public Library of Science", "Public Library of Science", "vocabularyEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries[0].authority", (Matcher)Matchers.is((Object)"112"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findByMetadataAndCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/search/byMetadataAndCollection", (Object[])new Object[0]).param("metadata", new String[]{"dc.type"}).param("collection", new String[]{collection.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VocabularyMatcher.matchProperties("common_types", "common_types", true, false))));
    }

    @Test
    public void findByMetadataAndCollectionWithMetadataWithoutVocabularyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/search/byMetadataAndCollection", (Object[])new Object[0]).param("metadata", new String[]{"dc.title"}).param("collection", new String[]{collection.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findByMetadataAndCollectionUnprocessableEntityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/search/byMetadataAndCollection", (Object[])new Object[0]).param("metadata", new String[]{"dc.not.exist"}).param("collection", new String[]{collection.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/search/byMetadataAndCollection", (Object[])new Object[0]).param("metadata", new String[]{"dc.type"}).param("collection", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findByMetadataAndCollectionBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test collection").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/search/byMetadataAndCollection", (Object[])new Object[0]).param("collection", new String[]{collection.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/search/byMetadataAndCollection", (Object[])new Object[0]).param("metadata", new String[]{"dc.type"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void linkedEntitiesWithExactParamTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/common_types/entries", (Object[])new Object[0]).param("filter", new String[]{"Animation"}).param("exact", new String[]{"true"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.entries", (Matcher)Matchers.contains(VocabularyMatcher.matchVocabularyEntry("Animation", "Animation", "vocabularyEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void linkedEntitiesWithFilterAndEntryIdTest() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/vocabularies/srsc/entries", (Object[])new Object[0]).param("filter", new String[]{"Research"}).param("entryID", new String[]{"VR131402"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

