/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EPersonRegistrationFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private ConverterService converterService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private SiteService siteService;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private Utils utils;
    private AuthorizationFeature epersonRegistrationFeature;
    public static final String[] SHIB_ONLY = new String[]{"org.dspace.authenticate.ShibAuthentication"};

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.epersonRegistrationFeature = this.authorizationFeatureService.find("epersonRegistration");
    }

    @Test
    public void userRegistrationEnabledSuccessTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest SiteRest2 = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)SiteRest2, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.epersonRegistrationFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void userRegistrationDisabledUnAuthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest SiteRest2 = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)SiteRest2, "self").getHref();
        this.configurationService.setProperty("user.registration", (Object)false);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.epersonRegistrationFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void userRegistrationEnabledShibTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest SiteRest2 = this.siteConverter.convert(site, Projection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)SiteRest2, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.epersonRegistrationFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.epersonRegistrationFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }
}

