/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.lang.reflect.Array;
import java.util.UUID;
import org.dspace.app.rest.matcher.GroupMatcher;
import org.dspace.app.rest.matcher.HalMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class EPersonMatcher {
    private EPersonMatcher() {
    }

    public static Matcher<? super Object> matchEPersonEntry(EPerson ePerson) {
        return Matchers.allOf(EPersonMatcher.matchProperties(ePerson), EPersonMatcher.matchLinks(ePerson.getID()));
    }

    public static Matcher<? super Object> matchEPersonOnEmail(String email) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.email", (Matcher)Matchers.is((Object)email)));
    }

    public static Matcher<? super Object> matchEPersonWithGroups(String email, String ... groups) {
        Matcher[] matchers = (Matcher[])Array.newInstance(Matcher.class, groups.length);
        for (int i = 0; i < groups.length; ++i) {
            matchers[i] = GroupMatcher.matchGroupWithName(groups[i]);
        }
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.email", (Matcher)Matchers.is((Object)email)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.groups._embedded.groups", (Matcher)Matchers.containsInAnyOrder((Matcher[])matchers)));
    }

    public static Matcher<? super Object> matchDefaultTestEPerson() {
        return Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson"))});
    }

    public static Matcher<? super Object> matchFullEmbeds() {
        return HalMatcher.matchEmbeds("groups[]");
    }

    public static Matcher<? super Object> matchLinks(UUID uuid) {
        return HalMatcher.matchLinks("http://localhost/api/eperson/epersons/" + uuid, "groups", "self");
    }

    public static Matcher<? super Object> matchProperties(EPerson ePerson) {
        return Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.uuid", (Matcher)Matchers.is((Object)ePerson.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.name", (Matcher)Matchers.is((Object)ePerson.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"eperson")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.canLogIn", (Matcher)Matchers.not((Matcher)Matchers.empty())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("eperson.firstname", ePerson.getFirstName()), MetadataMatcher.matchMetadata("eperson.lastname", ePerson.getLastName()))));
    }
}

