/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.projection;

import javax.annotation.Nullable;
import org.dspace.app.rest.model.LinkRest;
import org.dspace.app.rest.model.MockObject;
import org.dspace.app.rest.model.MockObjectRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.RestModel;
import org.dspace.app.rest.model.hateoas.HALResource;
import org.dspace.app.rest.projection.AbstractProjection;
import org.springframework.hateoas.Link;

public class MockProjection
extends AbstractProjection {
    public static final String NAME = "mock";
    private final Link linkToAdd;
    private final Object resourceToEmbed;

    public MockProjection(@Nullable Link linkToAdd, @Nullable Object resourceToEmbed) {
        this.linkToAdd = linkToAdd;
        this.resourceToEmbed = resourceToEmbed;
    }

    public String getName() {
        return NAME;
    }

    public <T> T transformModel(T modelObject) {
        if (modelObject instanceof MockObject) {
            MockObject mockObject = (MockObject)modelObject;
            if (mockObject.getStoredId() != null) {
                mockObject.setStoredId(mockObject.getStoredId() + 1L);
            }
            if (mockObject.getStoredValue() != null) {
                mockObject.setStoredValue(mockObject.getStoredValue() + "?");
            }
        }
        return modelObject;
    }

    public <T extends RestModel> T transformRest(T restObject) {
        if (restObject instanceof MockObjectRest) {
            MockObjectRest mockObjectRest = (MockObjectRest)restObject;
            if (mockObjectRest.getId() != null) {
                mockObjectRest.setId(Long.valueOf((Long)mockObjectRest.getId() * 3L));
            }
            if (mockObjectRest.getValue() != null) {
                mockObjectRest.setValue(mockObjectRest.getValue() + "!");
            }
        }
        return restObject;
    }

    public <T extends HALResource> T transformResource(T halResource) {
        if (this.linkToAdd != null) {
            halResource.add(this.linkToAdd);
        }
        if (this.resourceToEmbed != null) {
            halResource.embedResource("resource", this.resourceToEmbed);
        }
        return halResource;
    }

    public boolean allowEmbedding(HALResource<? extends RestAddressableModel> halResource, LinkRest linkRest, Link ... oldLinks) {
        return ((RestAddressableModel)halResource.getContent()).getEmbedLevel() < 2;
    }

    public boolean allowLinking(HALResource halResource, LinkRest linkRest) {
        return false;
    }
}

