/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.util.ArrayList;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.EPersonBuilder;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ShibbolethLoginFilterIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    private EPersonConverter ePersonConverter;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private Utils utils;
    public static final String[] PASS_ONLY = new String[]{"org.dspace.authenticate.PasswordAuthentication"};
    public static final String[] SHIB_ONLY = new String[]{"org.dspace.authenticate.ShibAuthentication"};
    private EPersonRest ePersonRest;
    private final String feature = "canChangePassword";

    @Before
    public void setup() throws Exception {
        super.setUp();
        AuthorizationFeature canChangePasswordFeature = this.authorizationFeatureService.find("canChangePassword");
        this.ePersonRest = this.ePersonConverter.convert(this.eperson, DefaultProjection.DEFAULT);
        this.configurationService.setProperty("rest.cors.allowed-origins", (Object)"${dspace.ui.url}, http://anotherdspacehost:4000");
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)SHIB_ONLY);
    }

    @Test
    public void testRedirectToDefaultDspaceUrl() throws Exception {
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail())).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000")).andReturn().getResponse().getHeader("Authorization");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testRedirectToGivenTrustedUrl() throws Exception {
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://localhost:8080/server/api/authn/status"}).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail())).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:8080/server/api/authn/status")).andReturn().getResponse().getHeader("Authorization");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canChangePassword"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.ePersonRest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testNoRedirectIfShibbolethDisabled() throws Exception {
        this.configurationService.setProperty("plugin.sequence.org.dspace.authenticate.AuthenticationMethod", (Object)PASS_ONLY);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://localhost:8080/server/api/authn/status"}).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testRedirectToAnotherGivenTrustedUrl() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://anotherdspacehost:4000/home"}).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail())).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://anotherdspacehost:4000/home"));
    }

    @Test
    public void testRedirectToGivenUntrustedUrl() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).param("redirectUrl", new String[]{"http://dspace.org"}).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail())).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testNoRedirectIfInvalidShibAttributes() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)"not-an-eperson@example.com")).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testRedirectRequiresShibAttributes() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testRedirectRequiresShibAttributes2() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void patchPassword() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("John", "Doe").withEmail("Johndoe@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        String newPassword = "newpassword";
        ArrayList<Operation> ops = new ArrayList<Operation>();
        AddOperation addOperation = new AddOperation("/password", (Object)newPassword);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/shibboleth", (Object[])new Object[0]).requestAttr("SHIB-MAIL", (Object)this.eperson.getEmail())).andExpect(MockMvcResultMatchers.status().is3xxRedirection()).andExpect(MockMvcResultMatchers.redirectedUrl((String)"http://localhost:4000")).andReturn().getResponse().getHeader("Authorization");
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authn/status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticated", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.authenticationMethod", (Matcher)Matchers.is((Object)"shibboleth")));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/eperson/epersons/" + ePerson.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isForbidden());
    }
}

