/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.DSpaceObjectConverter;
import org.dspace.app.rest.converter.IndexableObjectConverter;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.discovery.IndexableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollectionConverter
extends DSpaceObjectConverter<Collection, CollectionRest>
implements IndexableObjectConverter<Collection, CollectionRest> {
    @Autowired
    CollectionService collectionService;

    public CollectionRest convert(Collection collection, Projection projection) {
        CollectionRest resource = (CollectionRest)super.convert((DSpaceObject)collection, projection);
        resource.setArchivedItemsCount(this.collectionService.countArchivedItems(ContextUtil.obtainCurrentRequestContext(), collection));
        return resource;
    }

    protected CollectionRest newInstance() {
        return new CollectionRest();
    }

    public Class<Collection> getModelClass() {
        return Collection.class;
    }

    public boolean supportsModel(IndexableObject idxo) {
        return idxo.getIndexedObject() instanceof Collection;
    }
}

