/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.ParameterValueRest;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProcessConverter
implements DSpaceConverter<Process, ProcessRest> {
    @Lazy
    @Autowired
    private ConverterService converter;
    @Autowired
    private ProcessService processService;

    public ProcessRest convert(Process process, Projection projection) {
        ProcessRest processRest = new ProcessRest();
        processRest.setProjection(projection);
        processRest.setId((Serializable)process.getID());
        processRest.setScriptName(process.getName());
        processRest.setProcessId(process.getID());
        if (process.getEPerson() != null) {
            processRest.setUserId(process.getEPerson().getID());
        }
        processRest.setProcessStatus(process.getProcessStatus());
        processRest.setStartTime(process.getStartTime());
        processRest.setEndTime(process.getFinishedTime());
        processRest.setParameterRestList(this.processService.getParameters(process).stream().map(x -> (ParameterValueRest)this.converter.toRest(x, projection)).collect(Collectors.toList()));
        return processRest;
    }

    public Class<Process> getModelClass() {
        return Process.class;
    }
}

