/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.ProcessStatus;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.scripts.Process;
import org.dspace.scripts.ProcessQueryParameterContainer;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.process")
public class ProcessRestRepository
extends DSpaceRestRepository<ProcessRest, Integer> {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ProcessService processService;
    @Autowired
    private ConverterService converterService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private EPersonService epersonService;

    @PostConstruct
    public void init() throws SQLException, AuthorizeException, IOException {
        Context context = new Context();
        this.processService.failRunningProcesses(context);
        context.complete();
    }

    @PreAuthorize(value="hasPermission(#id, 'PROCESS', 'READ')")
    public ProcessRest findOne(Context context, Integer id) {
        try {
            Process process = this.processService.find(context, id.intValue());
            if (process == null) {
                return null;
            }
            return (ProcessRest)this.converter.toRest((Object)process, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ProcessRest> findAll(Context context, Pageable pageable) {
        try {
            int total = this.processService.countTotal(context);
            List processes = this.processService.findAll(context, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(processes, pageable, (long)total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="own")
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<ProcessRest> findByCurrentUser(Pageable pageable) {
        try {
            Context context = this.obtainContext();
            long total = this.processService.countByUser(context, context.getCurrentUser());
            List processes = this.processService.findByUser(context, context.getCurrentUser(), pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(processes, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<BitstreamRest> getProcessBitstreams(Integer processId) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        Process process = this.getProcess(processId, context);
        List bitstreams = this.processService.getBitstreams(context, process);
        return bitstreams.stream().map(bitstream -> (BitstreamRest)this.converterService.toRest(bitstream, Projection.DEFAULT)).collect(Collectors.toList());
    }

    private Process getProcess(Integer processId, Context context) throws SQLException, AuthorizeException {
        Process process = this.processService.find(context, processId.intValue());
        if (process == null) {
            throw new ResourceNotFoundException("Process with id " + processId + " was not found");
        }
        if (context.getCurrentUser() == null || !context.getCurrentUser().equals((Object)process.getEPerson()) && !this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("The current user is not eligible to view the process with id: " + processId);
        }
        return process;
    }

    public BitstreamRest getProcessBitstreamByType(Integer processId, String type) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        Process process = this.getProcess(processId, context);
        Bitstream bitstream = this.processService.getBitstream(context, process, type);
        return (BitstreamRest)this.converterService.toRest((Object)bitstream, this.utils.obtainProjection());
    }

    protected void delete(Context context, Integer integer) throws AuthorizeException, RepositoryMethodNotImplementedException {
        try {
            this.processService.delete(context, this.processService.find(context, integer.intValue()));
        }
        catch (IOException | SQLException e) {
            log.error("Something went wrong trying to find Process with id: " + integer, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byProperty")
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ProcessRest> findProcessesByProperty(@Parameter(value="userId") UUID ePersonUuid, @Parameter(value="scriptName") String scriptName, @Parameter(value="processStatus") String processStatusString, Pageable pageable) throws SQLException {
        if (StringUtils.isBlank((CharSequence)scriptName) && ePersonUuid == null && StringUtils.isBlank((CharSequence)processStatusString)) {
            throw new DSpaceBadRequestException("Either a name, user UUID or ProcessStatus should be provided");
        }
        Context context = this.obtainContext();
        EPerson ePerson = null;
        if (ePersonUuid != null && (ePerson = (EPerson)this.epersonService.find(context, ePersonUuid)) == null) {
            throw new DSpaceBadRequestException("No EPerson with the given UUID is found");
        }
        ProcessStatus processStatus = StringUtils.isBlank((CharSequence)processStatusString) ? null : ProcessStatus.valueOf((String)processStatusString);
        ProcessQueryParameterContainer processQueryParameterContainer = this.createProcessQueryParameterContainer(scriptName, ePerson, processStatus);
        this.handleSearchSort(pageable, processQueryParameterContainer);
        List processes = this.processService.search(context, processQueryParameterContainer, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
        return this.converterService.toRestPage(processes, pageable, (long)this.processService.countSearch(context, processQueryParameterContainer), this.utils.obtainProjection());
    }

    private void handleSearchSort(Pageable pageable, ProcessQueryParameterContainer processQueryParameterContainer) {
        Iterator iterator;
        Sort sort = pageable.getSort();
        if (sort != null && (iterator = sort.iterator()).hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            if (StringUtils.equalsIgnoreCase((CharSequence)order.getProperty(), (CharSequence)"startTime")) {
                processQueryParameterContainer.setSortProperty("startTime");
                processQueryParameterContainer.setSortOrder(order.getDirection().name());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)order.getProperty(), (CharSequence)"endTime")) {
                processQueryParameterContainer.setSortProperty("finishedTime");
                processQueryParameterContainer.setSortOrder(order.getDirection().name());
            } else {
                throw new DSpaceBadRequestException("The given sort option was invalid: " + order.getProperty());
            }
            if (iterator.hasNext()) {
                throw new DSpaceBadRequestException("Only one sort method is supported, can't give multiples");
            }
        }
    }

    private ProcessQueryParameterContainer createProcessQueryParameterContainer(String scriptName, EPerson ePerson, ProcessStatus processStatus) {
        ProcessQueryParameterContainer processQueryParameterContainer = new ProcessQueryParameterContainer();
        if (StringUtils.isNotBlank((CharSequence)scriptName)) {
            processQueryParameterContainer.addToQueryParameterMap("name", (Object)scriptName);
        }
        if (ePerson != null) {
            processQueryParameterContainer.addToQueryParameterMap("ePerson", (Object)ePerson);
        }
        if (processStatus != null) {
            processQueryParameterContainer.addToQueryParameterMap("processStatus", (Object)processStatus);
        }
        return processQueryParameterContainer;
    }

    public Class<ProcessRest> getDomainClass() {
        return ProcessRest.class;
    }
}

