/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.services.RequestService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="extractorOf")
public class ExtractorOfAInprogressSubmissionInformations {
    @Autowired(required=true)
    private WorkflowItemService workflowItemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private VersioningService versionService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private RequestService requestService;

    public Integer getAInprogressSubmissionID(@Nullable HttpServletRequest request, Integer versionHistoryId) {
        Context context = this.getContext(request);
        if (Objects.nonNull(versionHistoryId)) {
            try {
                VersionHistory versionHistory = (VersionHistory)this.versionHistoryService.find(context, versionHistoryId.intValue());
                if (Objects.nonNull(versionHistory)) {
                    Version oldestVersion = this.versionHistoryService.getLatestVersion(context, versionHistory);
                    WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(context, oldestVersion.getItem());
                    if (Objects.nonNull(workspaceItem)) {
                        return workspaceItem.getID();
                    }
                    WorkflowItem workflowItem = this.workflowItemService.findByItem(context, oldestVersion.getItem());
                    if (Objects.nonNull(workflowItem)) {
                        return workflowItem.getID();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public String getAInprogressSubmissionTarget(@Nullable HttpServletRequest request, Integer versionHistoryId) {
        Context context = this.getContext(request);
        if (Objects.nonNull(versionHistoryId)) {
            try {
                VersionHistory versionHistory = (VersionHistory)this.versionHistoryService.find(context, versionHistoryId.intValue());
                if (Objects.nonNull(versionHistory)) {
                    Version oldestVersion = this.versionHistoryService.getLatestVersion(context, versionHistory);
                    if (Objects.nonNull(this.workspaceItemService.findByItem(context, oldestVersion.getItem()))) {
                        return "workspaceitem";
                    }
                    if (Objects.nonNull(this.workflowItemService.findByItem(context, oldestVersion.getItem()))) {
                        return "workflowitem";
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return "";
    }

    public Integer getVersionIdByItemUUID(@Nullable HttpServletRequest request, UUID uuid) {
        Context context = this.getContext(request);
        if (Objects.nonNull(uuid)) {
            try {
                Item item = (Item)this.itemService.find(context, uuid);
                if (Objects.nonNull(item)) {
                    Version version = this.versionService.getVersion(context, item);
                    return Objects.nonNull(version) ? version.getID() : null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    private Context getContext(HttpServletRequest request) {
        HttpServletRequest currentRequest = this.requestService.getCurrentRequest().getHttpServletRequest();
        return Objects.nonNull(request) ? ContextUtil.obtainContext((HttpServletRequest)request) : ContextUtil.obtainContext((HttpServletRequest)currentRequest);
    }
}

