/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(ResourcePolicyRestPermissionEvaluatorPlugin.class);
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.READ.equals((Object)restPermission) && !DSpaceRestPermission.DELETE.equals((Object)restPermission) || !StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"resourcepolicy")) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((HttpServletRequest)request.getHttpServletRequest());
        EPerson ePerson = null;
        try {
            ePerson = this.ePersonService.findByEmail(context, (String)authentication.getPrincipal());
            Integer dsoId = Integer.parseInt(targetId.toString());
            if (ePerson == null) {
                return false;
            }
            if (this.resourcePolicyService.isMyResourcePolicy(context, ePerson, dsoId)) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

