/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.AddPatchOperation;
import org.dspace.app.rest.submit.factory.impl.BitstreamResourcePolicyUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.submit.model.UploadConfiguration;
import org.dspace.submit.model.UploadConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class BitstreamResourcePolicyAddPatchOperation
extends AddPatchOperation<AccessConditionDTO> {
    @Autowired
    ItemService itemService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    UploadConfigurationService uploadConfigurationService;

    void add(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String[] splitAbsPath = this.getAbsolutePath(path).split("/");
        String[] splitPath = path.split("/");
        Item item = source.getItem();
        List bundle = this.itemService.getBundles(item, "ORIGINAL");
        UploadConfiguration uploadConfig = (UploadConfiguration)this.uploadConfigurationService.getMap().get(splitPath[2]);
        for (Bundle bb : bundle) {
            int idx = 0;
            for (Bitstream bitstream : bb.getBitstreams()) {
                if (idx == Integer.parseInt(splitAbsPath[1])) {
                    List<Object> newAccessConditions = new ArrayList<AccessConditionDTO>();
                    if (splitAbsPath.length == 3) {
                        this.resourcePolicyService.removePolicies(context, (DSpaceObject)bitstream, ResourcePolicy.TYPE_CUSTOM);
                        newAccessConditions = this.evaluateArrayObject((LateObjectEvaluator)value);
                    } else if (splitAbsPath.length == 4) {
                        newAccessConditions.add((AccessConditionDTO)this.evaluateSingleObject((LateObjectEvaluator)value));
                    }
                    if (CollectionUtils.isNotEmpty(newAccessConditions)) {
                        BitstreamResourcePolicyUtils.findApplyResourcePolicy((Context)context, (UploadConfiguration)uploadConfig, (DSpaceObject)bitstream, newAccessConditions);
                    }
                }
                ++idx;
            }
        }
    }

    protected Class<AccessConditionDTO[]> getArrayClassForEvaluation() {
        return AccessConditionDTO[].class;
    }

    protected Class<AccessConditionDTO> getClassForEvaluation() {
        return AccessConditionDTO.class;
    }
}

