/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.Filter;
import org.dspace.app.rest.filter.DSpaceRequestContextFilter;
import org.dspace.app.rest.model.hateoas.DSpaceLinkRelationProvider;
import org.dspace.app.rest.parameter.resolver.SearchFilterResolver;
import org.dspace.app.rest.utils.ApplicationConfig;
import org.dspace.app.rest.utils.DSpaceAPIRequestLoggingFilter;
import org.dspace.app.rest.utils.DSpaceConfigurationInitializer;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.dspace.app.sitemap.GenerateSitemaps;
import org.dspace.app.solrdatabaseresync.SolrDatabaseResyncCli;
import org.dspace.app.util.DSpaceContextListener;
import org.dspace.google.GoogleAsyncEventListener;
import org.dspace.utils.servlet.DSpaceWebappServletFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
@EnableScheduling
@EnableCaching
public class Application
extends SpringBootServletInitializer {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    @Autowired
    private ApplicationConfig configuration;
    @Autowired
    private GoogleAsyncEventListener googleAsyncEventListener;

    @Scheduled(cron="${sitemap.cron:-}")
    public void generateSitemap() throws IOException, SQLException {
        GenerateSitemaps.generateSitemapsScheduled();
    }

    @Scheduled(cron="${solr-database-resync.cron:-}")
    public void solrDatabaseResync() throws Exception {
        SolrDatabaseResyncCli.runScheduled();
    }

    @Scheduled(cron="${google.analytics.cron:-}")
    public void sendGoogleAnalyticsEvents() {
        this.googleAsyncEventListener.sendCollectedEvents();
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class}).initializers(new ApplicationContextInitializer[]{new DSpaceKernelInitializer(), new DSpaceConfigurationInitializer()});
    }

    @Bean
    @Order(value=2)
    protected DSpaceContextListener dspaceContextListener() {
        return new DSpaceContextListener();
    }

    @Bean
    @Order(value=1)
    protected Filter dspaceWebappServletFilter() {
        return new DSpaceWebappServletFilter();
    }

    @Bean
    @Order(value=2)
    protected Filter dspaceRequestContextFilter() {
        return new DSpaceRequestContextFilter();
    }

    @Bean
    @Order(value=3)
    protected Filter dspaceApiLoggingRequest() {
        return new DSpaceAPIRequestLoggingFilter();
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    protected LinkRelationProvider dspaceLinkRelationProvider() {
        return new DSpaceLinkRelationProvider();
    }

    @Bean
    public WebMvcConfigurer webMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(@NonNull CorsRegistry registry) {
                String[] corsAllowedOrigins = Application.this.configuration.getCorsAllowedOrigins(Application.this.configuration.getCorsAllowedOriginsConfig());
                String[] iiifAllowedOrigins = Application.this.configuration.getCorsAllowedOrigins(Application.this.configuration.getIiifAllowedOriginsConfig());
                String[] signpostingAllowedOrigins = Application.this.configuration.getCorsAllowedOrigins(Application.this.configuration.getSignpostingAllowedOriginsConfig());
                boolean corsAllowCredentials = Application.this.configuration.getCorsAllowCredentials();
                boolean iiifAllowCredentials = Application.this.configuration.getIiifAllowCredentials();
                boolean signpostingAllowCredentials = Application.this.configuration.getSignpostingAllowCredentials();
                if (corsAllowedOrigins != null) {
                    registry.addMapping("/api/**").allowedMethods(new String[]{"*"}).allowCredentials(corsAllowCredentials).allowedOrigins(corsAllowedOrigins).allowedHeaders(new String[]{"Accept", "Authorization", "Content-Type", "Origin", "X-On-Behalf-Of", "X-Requested-With", "X-XSRF-TOKEN", "X-CORRELATION-ID", "X-REFERRER", "x-recaptcha-token"}).exposedHeaders(new String[]{"Authorization", "DSPACE-XSRF-TOKEN", "Location", "WWW-Authenticate"});
                }
                if (iiifAllowedOrigins != null) {
                    registry.addMapping("/iiif/**").allowedMethods(new String[]{"*"}).allowCredentials(iiifAllowCredentials).allowedOrigins(iiifAllowedOrigins).allowedHeaders(new String[]{"Accept", "Authorization", "Content-Type", "Origin", "X-On-Behalf-Of", "X-Requested-With", "X-XSRF-TOKEN", "X-CORRELATION-ID", "X-REFERRER", "x-recaptcha-token"}).exposedHeaders(new String[]{"Authorization", "DSPACE-XSRF-TOKEN", "Location", "WWW-Authenticate"});
                }
                if (signpostingAllowedOrigins != null) {
                    registry.addMapping("/signposting/**").allowedMethods(new String[]{"*"}).allowCredentials(signpostingAllowCredentials).allowedOrigins(signpostingAllowedOrigins).allowedHeaders(new String[]{"Accept", "Authorization", "Content-Type", "Origin", "X-On-Behalf-Of", "X-Requested-With", "X-XSRF-TOKEN", "X-CORRELATION-ID", "X-REFERRER", "x-recaptcha-token", "access-control-allow-headers"}).exposedHeaders(new String[]{"Authorization", "DSPACE-XSRF-TOKEN", "Location", "WWW-Authenticate"});
                }
            }

            public void addViewControllers(ViewControllerRegistry registry) {
                registry.addViewController("/").setViewName("forward:/index.html");
            }

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/browser/**"}).addResourceLocations(new String[]{"/webjars/hal-browser/ad9b865/"});
                registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"/webjars/"});
            }

            public void addArgumentResolvers(@NonNull List<HandlerMethodArgumentResolver> argumentResolvers) {
                argumentResolvers.add(new SearchFilterResolver());
            }
        };
    }
}

