/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.WorkflowStepRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.workflowdefinition.steps")
public class WorkflowDefinitionStepsLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<WorkflowStepRest> getSteps(@Nullable HttpServletRequest request, String workflowName, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            List steps = this.xmlWorkflowFactory.getWorkflowByName(workflowName).getSteps();
            Pageable pageable = optionalPageable != null ? optionalPageable : PageRequest.of((int)0, (int)20);
            return this.converter.toRestPage(steps, pageable, projection);
        }
        catch (WorkflowConfigurationException e) {
            throw new ResourceNotFoundException("No workflow with name " + workflowName + " is configured");
        }
    }
}

