/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canSubmit", description="It can be used to verify if a user has rights to submit anything.")
public class SubmitFeature
implements AuthorizationFeature {
    public static final String NAME = "canSubmit";
    @Autowired
    AuthorizeService authService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    Utils utils;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException, SearchServiceException {
        if (object instanceof SiteRest) {
            return this.collectionService.countCollectionsWithSubmit("", context, null) > 0;
        }
        if (object instanceof CollectionRest) {
            Collection collection = (Collection)this.utils.getDSpaceAPIObjectFromRest(context, object);
            return this.authService.authorizeActionBoolean(context, (DSpaceObject)collection, 3);
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.collection", "core.site"};
    }
}

