/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.exception;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.exception.ResourceAlreadyExistsException;
import org.dspace.app.rest.exception.EPersonNameNotProvidedException;
import org.dspace.app.rest.exception.GroupHasPendingWorkflowTasksException;
import org.dspace.app.rest.exception.GroupNameNotProvidedException;
import org.dspace.app.rest.exception.InvalidSearchRequestException;
import org.dspace.app.rest.exception.MethodNotAllowedException;
import org.dspace.app.rest.exception.MissingParameterException;
import org.dspace.app.rest.exception.PasswordNotValidException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RESTBitstreamNotFoundException;
import org.dspace.app.rest.exception.RESTEmptyWorkflowGroupException;
import org.dspace.app.rest.exception.TranslatableException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.exception.WrongCurrentPasswordException;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.orcid.exception.OrcidValidationException;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.support.QueryMethodParameterConversionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class DSpaceApiExceptionControllerAdvice
extends ResponseEntityExceptionHandler {
    private static final Logger log = LogManager.getLogger();
    private static final String[] LOG_AS_ERROR_DEFAULT = new String[]{"422"};
    private static final String P_LOG_AS_ERROR = "logging.server.include-stacktrace-for-httpcode";
    @Inject
    private ConfigurationService configurationService;

    @ExceptionHandler(value={AuthorizeException.class, RESTAuthorizationException.class, AccessDeniedException.class})
    protected void handleAuthorizeException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        Context context = ContextUtil.obtainContext(request);
        if (Objects.nonNull(context.getCurrentUser())) {
            this.sendErrorResponse(request, response, ex, "Access is denied", 403);
        } else {
            this.sendErrorResponse(request, response, ex, "Authentication is required", 401);
        }
    }

    @ExceptionHandler(value={InvalidCsrfTokenException.class, MissingCsrfTokenException.class})
    protected void csrfTokenException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "Access is denied. Invalid CSRF token.", 403);
    }

    @ExceptionHandler(value={IllegalArgumentException.class, MultipartException.class})
    protected void handleWrongRequestException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "Request is invalid or incorrect", 400);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    protected void handleMaxUploadSizeExceededException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "Request entity is too large", 413);
    }

    @ExceptionHandler(value={SQLException.class})
    protected void handleSQLException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "An internal database error occurred", 500);
    }

    @ExceptionHandler(value={IOException.class})
    protected void handleIOException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "An internal read or write operation failed", 500);
    }

    @ExceptionHandler(value={MethodNotAllowedException.class})
    protected void methodNotAllowedException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "Method is not allowed or supported", 405);
    }

    @ExceptionHandler(value={UnprocessableEntityException.class, ResourceAlreadyExistsException.class})
    protected void handleUnprocessableEntityException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, "Unprocessable or invalid entity", HttpStatus.UNPROCESSABLE_ENTITY.value());
    }

    @ExceptionHandler(value={InvalidSearchRequestException.class})
    protected void handleInvalidSearchRequestException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, "Invalid search request", HttpStatus.UNPROCESSABLE_ENTITY.value());
    }

    @ExceptionHandler(value={OrcidValidationException.class})
    protected void handleOrcidValidationException(HttpServletRequest request, HttpServletResponse response, OrcidValidationException ex) throws IOException {
        this.sendErrorResponse(request, response, (Exception)ex, ex.getMessage(), HttpStatus.UNPROCESSABLE_ENTITY.value());
    }

    @ExceptionHandler(value={RESTEmptyWorkflowGroupException.class, EPersonNameNotProvidedException.class, GroupNameNotProvidedException.class, GroupHasPendingWorkflowTasksException.class, PasswordNotValidException.class, RESTBitstreamNotFoundException.class})
    protected void handleCustomUnprocessableEntityException(HttpServletRequest request, HttpServletResponse response, TranslatableException ex) throws IOException {
        Context context = ContextUtil.obtainContext(request);
        this.sendErrorResponse(request, response, null, ex.getLocalizedMessage(context), HttpStatus.UNPROCESSABLE_ENTITY.value());
    }

    @ExceptionHandler(value={QueryMethodParameterConversionException.class})
    protected void ParameterConversionException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, "A required parameter is invalid", HttpStatus.BAD_REQUEST.value());
    }

    @ExceptionHandler(value={MissingParameterException.class})
    protected void MissingParameterException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, null, "A required parameter is missing", HttpStatus.BAD_REQUEST.value());
    }

    @ExceptionHandler(value={WrongCurrentPasswordException.class})
    protected void handleInvalidPasswordException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, ex.getMessage(), 403);
    }

    @ExceptionHandler(value={InvalidReCaptchaException.class})
    protected void handleInvalidCaptchaTokenRequestException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        this.sendErrorResponse(request, response, ex, "Invalid captcha token", 403);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleMissingServletRequestParameter(ex, headers, HttpStatus.BAD_REQUEST, request);
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return super.handleTypeMismatch(ex, headers, HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={Exception.class})
    protected void handleGenericException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        ResponseStatus responseStatusAnnotation = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        int returnCode = 0;
        returnCode = responseStatusAnnotation != null ? responseStatusAnnotation.code().value() : 500;
        this.sendErrorResponse(request, response, ex, "An exception has occurred", returnCode);
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, Exception ex, String message, int statusCode) throws IOException {
        String[] error_codes;
        request.setAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE, (Object)ex);
        HashSet<Integer> LOG_AS_ERROR = new HashSet<Integer>();
        for (String code : error_codes = this.configurationService.getArrayProperty(P_LOG_AS_ERROR, LOG_AS_ERROR_DEFAULT)) {
            try {
                LOG_AS_ERROR.add(Integer.valueOf(code));
            }
            catch (NumberFormatException e) {
                log.warn("Non-integer HTTP status code {} in {}", (Object)code, (Object)P_LOG_AS_ERROR);
            }
        }
        if (HttpStatus.valueOf((int)statusCode).is5xxServerError() || LOG_AS_ERROR.contains(statusCode)) {
            log.error("{} (status:{})", (Object)message, (Object)statusCode, (Object)ex);
        } else if (HttpStatus.valueOf((int)statusCode).is4xxClientError()) {
            String location;
            String exceptionMessage;
            if (null == ex) {
                exceptionMessage = "none";
                location = "unknown";
            } else {
                exceptionMessage = ex.getMessage();
                StackTraceElement[] trace = ex.getStackTrace();
                location = trace.length <= 0 ? "unknown" : trace[0].toString();
            }
            log.warn("{} (status:{} exception: {} at: {})", (Object)message, (Object)statusCode, (Object)exceptionMessage, (Object)location);
        }
        response.sendError(statusCode, message);
    }
}

