/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.RelationshipTypeRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="core.entitytype.relationshiptypes")
public class EntityTypeRelationshipLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RelationshipTypeService relationshipTypeService;

    public Page<RelationshipTypeRest> getEntityTypeRelationship(@Nullable HttpServletRequest request, Integer id, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Pageable pageable = this.utils.getPageable(optionalPageable);
            EntityType entityType = (EntityType)this.entityTypeService.find(context, id.intValue());
            if (Objects.isNull(entityType)) {
                throw new ResourceNotFoundException("No such EntityType: " + id);
            }
            int total = this.relationshipTypeService.countByEntityType(context, entityType);
            List list = this.relationshipTypeService.findByEntityType(context, entityType, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(list, pageable, total, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

