/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.RelationshipTypeRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.EntityType;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.relationshiptype")
public class RelationshipTypeRestRepository
extends DSpaceRestRepository<RelationshipTypeRest, Integer> {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;

    @Override
    @PreAuthorize(value="permitAll()")
    public RelationshipTypeRest findOne(Context context, Integer integer) {
        try {
            return (RelationshipTypeRest)this.converter.toRest((RelationshipType)this.relationshipTypeService.find(context, integer.intValue()), this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Page<RelationshipTypeRest> findAll(Context context, Pageable pageable) {
        try {
            List relationshipTypes = this.relationshipTypeService.findAll(context);
            return this.converter.toRestPage(relationshipTypes, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byEntityType")
    public Page<RelationshipTypeRest> findByEntityType(@Parameter(value="type", required=true) String type, Pageable pageable) throws SQLException {
        Context context = this.obtainContext();
        EntityType entityType = this.entityTypeService.findByEntityType(context, type);
        if (Objects.isNull(entityType)) {
            throw new DSpaceBadRequestException("EntityType with name: " + type + " not found");
        }
        List relationshipTypes = this.relationshipTypeService.findByEntityType(context, entityType, Integer.valueOf(Math.toIntExact(pageable.getPageSize())), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
        int total = this.relationshipTypeService.countByEntityType(context, entityType);
        return this.converter.toRestPage(relationshipTypes, pageable, total, this.utils.obtainProjection());
    }

    @Override
    public Class<RelationshipTypeRest> getDomainClass() {
        return RelationshipTypeRest.class;
    }
}

