/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.net.URI;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ResearcherProfileRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.patch.ResourcePatch;
import org.dspace.app.rest.security.DSpacePermissionEvaluator;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.ResearcherProfileService;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="eperson.profile")
@ConditionalOnProperty(value={"researcher-profile.entity-type"})
public class ResearcherProfileRestRepository
extends DSpaceRestRepository<ResearcherProfileRest, UUID> {
    public static final String NO_VISIBILITY_CHANGE_MSG = "Refused to perform the Researcher Profile patch based on a token without changing the visibility";
    @Autowired
    private ResearcherProfileService researcherProfileService;
    @Autowired
    private DSpacePermissionEvaluator permissionEvaluator;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ResourcePatch<ResearcherProfile> resourcePatch;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'PROFILE', 'READ')")
    public ResearcherProfileRest findOne(Context context, UUID id) {
        try {
            ResearcherProfile profile = this.researcherProfileService.findById(context, id);
            if (profile == null) {
                return null;
            }
            return (ResearcherProfileRest)this.converter.toRest(profile, this.utils.obtainProjection());
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="isAuthenticated()")
    protected ResearcherProfileRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        UUID id = this.getEPersonIdFromRequest(context);
        if (this.isNotAuthorized(id, "WRITE")) {
            throw new AuthorizeException("User unauthorized to create a new profile for user " + id);
        }
        EPerson ePerson = (EPerson)this.ePersonService.find(context, id);
        if (ePerson == null) {
            throw new UnprocessableEntityException("No EPerson exists with id: " + id);
        }
        try {
            ResearcherProfile newProfile = this.researcherProfileService.createAndReturn(context, ePerson);
            return (ResearcherProfileRest)this.converter.toRest(newProfile, this.utils.obtainProjection());
        }
        catch (SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected ResearcherProfileRest createAndReturn(Context context, List<String> list) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        if (CollectionUtils.isEmpty(list) || list.size() > 1) {
            throw new IllegalArgumentException("Uri list must contain exactly one element");
        }
        UUID id = this.getEPersonIdFromRequest(context);
        if (this.isNotAuthorized(id, "WRITE")) {
            throw new AuthorizeException("User unauthorized to create a new profile for user " + id);
        }
        EPerson ePerson = (EPerson)this.ePersonService.find(context, id);
        if (ePerson == null) {
            throw new UnprocessableEntityException("No EPerson exists with id: " + id);
        }
        try {
            ResearcherProfile newProfile = this.researcherProfileService.claim(context, ePerson, URI.create(list.get(0)));
            return (ResearcherProfileRest)this.converter.toRest(newProfile, this.utils.obtainProjection());
        }
        catch (SearchServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Page<ResearcherProfileRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'PROFILE', 'DELETE')")
    protected void delete(Context context, UUID id) {
        try {
            this.researcherProfileService.deleteById(context, id);
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'PROFILE', #patch)")
    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, UUID id, Patch patch) throws SQLException, AuthorizeException {
        ResearcherProfile profile = this.researcherProfileService.findById(context, id);
        if (profile == null) {
            throw new ResourceNotFoundException(apiCategory + "." + model + " with id: " + id + " not found");
        }
        this.resourcePatch.patch(context, profile, patch.getOperations());
    }

    @Override
    public Class<ResearcherProfileRest> getDomainClass() {
        return ResearcherProfileRest.class;
    }

    private UUID getEPersonIdFromRequest(Context context) {
        HttpServletRequest request = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        String ePersonId = request.getParameter("eperson");
        if (ePersonId == null) {
            return context.getCurrentUser().getID();
        }
        UUID uuid = UUIDUtils.fromString((String)ePersonId);
        if (uuid == null) {
            throw new DSpaceBadRequestException("The provided eperson parameter is not a valid uuid");
        }
        return uuid;
    }

    private boolean isNotAuthorized(UUID id, String permission) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return !this.permissionEvaluator.hasPermission(authentication, id, "PROFILE", permission);
    }
}

