/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.alerts.AllowSessionsEnum;
import org.dspace.alerts.SystemWideAlert;
import org.dspace.alerts.service.SystemWideAlertService;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.SystemWideAlertRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.systemwidealert")
public class SystemWideAlertRestRepository
extends DSpaceRestRepository<SystemWideAlertRest, Integer> {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private SystemWideAlertService systemWideAlertService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected SystemWideAlertRest createAndReturn(Context context) throws SQLException, AuthorizeException {
        SystemWideAlert systemWideAlert = this.createSystemWideAlert(context);
        return (SystemWideAlertRest)this.converter.toRest(systemWideAlert, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public SystemWideAlertRest findOne(Context context, Integer id) {
        try {
            SystemWideAlert systemWideAlert = this.systemWideAlertService.find(context, id.intValue());
            if (systemWideAlert == null) {
                throw new ResourceNotFoundException("systemWideAlert with id " + systemWideAlert.getID() + " was not found");
            }
            if (!systemWideAlert.isActive() && !this.authorizeService.isAdmin(context)) {
                throw new AuthorizeException("Non admin users are not allowed to retrieve inactive alerts");
            }
            return (SystemWideAlertRest)this.converter.toRest(systemWideAlert, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<SystemWideAlertRest> findAll(Context context, Pageable pageable) {
        try {
            List systemWideAlerts = this.systemWideAlertService.findAll(context, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(systemWideAlerts, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected SystemWideAlertRest put(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, JsonNode jsonNode) throws SQLException, AuthorizeException {
        SystemWideAlertRest systemWideAlertRest;
        try {
            systemWideAlertRest = (SystemWideAlertRest)new ObjectMapper().readValue(jsonNode.toString(), SystemWideAlertRest.class);
        }
        catch (JsonProcessingException e) {
            throw new UnprocessableEntityException("Cannot parse JSON in request body", e);
        }
        if (systemWideAlertRest == null || StringUtils.isBlank((CharSequence)systemWideAlertRest.getMessage())) {
            throw new UnprocessableEntityException("system alert message cannot be blank");
        }
        SystemWideAlert systemWideAlert = this.systemWideAlertService.find(context, id.intValue());
        if (systemWideAlert == null) {
            throw new ResourceNotFoundException("system wide alert with id: " + id + " not found");
        }
        systemWideAlert.setMessage(systemWideAlertRest.getMessage());
        systemWideAlert.setAllowSessions(AllowSessionsEnum.fromString((String)systemWideAlertRest.getAllowSessions()));
        systemWideAlert.setCountdownTo(systemWideAlertRest.getCountdownTo());
        systemWideAlert.setActive(systemWideAlertRest.isActive());
        this.systemWideAlertService.update(context, systemWideAlert);
        context.commit();
        return (SystemWideAlertRest)this.converter.toRest(systemWideAlert, this.utils.obtainProjection());
    }

    private SystemWideAlert createSystemWideAlert(Context context) throws SQLException, AuthorizeException {
        SystemWideAlert systemWideAlert;
        SystemWideAlertRest systemWideAlertRest;
        List all = this.systemWideAlertService.findAll(context);
        if (!all.isEmpty()) {
            throw new DSpaceBadRequestException("A system wide alert already exists, no new value can be created. Try updating the existing one.");
        }
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = req.getInputStream();
            systemWideAlertRest = (SystemWideAlertRest)mapper.readValue((InputStream)input, SystemWideAlertRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", e1);
        }
        try {
            systemWideAlert = this.systemWideAlertService.create(context, systemWideAlertRest.getMessage(), AllowSessionsEnum.fromString((String)systemWideAlertRest.getAllowSessions()), systemWideAlertRest.getCountdownTo(), systemWideAlertRest.isActive());
            this.systemWideAlertService.update(context, systemWideAlert);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return systemWideAlert;
    }

    @PreAuthorize(value="permitAll()")
    @SearchRestMethod(name="active")
    public Page<SystemWideAlertRest> findAllActive(Pageable pageable) {
        Context context = this.obtainContext();
        try {
            List systemWideAlerts = this.systemWideAlertService.findAllActive(context, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(systemWideAlerts, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<SystemWideAlertRest> getDomainClass() {
        return SystemWideAlertRest.class;
    }
}

