/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.handler;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.repository.handler.ExternalSourceEntryItemUriListHandler;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalSourceItemUriListHandler
extends ExternalSourceEntryItemUriListHandler<Item> {
    @Autowired
    private ItemService itemService;

    @Override
    public boolean supports(List<String> uriList, String method, Class clazz) {
        return clazz == Item.class;
    }

    @Override
    public Item handle(Context context, HttpServletRequest request, List<String> uriList) throws SQLException, AuthorizeException {
        return this.getObjectFromUriList(context, uriList);
    }

    @Override
    public boolean validate(Context context, HttpServletRequest request, List<String> uriList) throws AuthorizeException {
        return uriList.size() <= 1;
    }

    private Item getObjectFromUriList(Context context, List<String> uriList) {
        Item item = null;
        String url = uriList.get(0);
        Pattern pattern = Pattern.compile("\\/api\\/core\\/items\\/(.*)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new DSpaceBadRequestException("The uri: " + url + " doesn't resolve to an item");
        }
        String id = matcher.group(1);
        UUID itemId = UUID.fromString(id);
        try {
            item = (Item)this.itemService.find(context, itemId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return item;
    }
}

